function displayqmu(md)
%DISPLAYQMU - display qmu computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   qmu computation from model md, only if requested.
%
%   Usage:
%      displayqmu(md)

disp(sprintf('      ''%s''','qmu using Dakota'));

for i=1:numel(md.variables)
    disp(sprintf('         variables%s:  (arrays of each variable class)',...
        string_dim(md.variables,i)));
    fnames=fieldnames(md.variables(i));
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
            fnames{j},size(md.variables.(fnames{j})),class(md.variables.(fnames{j}))));
    end
end


for i=1:numel(md.responses)
    disp(sprintf('         responses%s:  (arrays of each response class)',...
        string_dim(md.responses,i)));
    fnames=fieldnames(md.responses(i));
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
            fnames{j},size(md.responses.(fnames{j})),class(md.responses.(fnames{j}))));
    end
end


disp(sprintf('         qmu_method:  (array of dakota_method class)'));
for i=1:numel(md.qmu_method);
    if strcmp(class(md.qmu_method(i)),'dakota_method')
        disp(sprintf('            method%s :    ''%s''',...
            string_dim(md.qmu_method,i),md.qmu_method(i).method));
    end
end

for i=1:numel(md.qmu_params)
    disp(sprintf('         qmu_params%s:  (array of method-independent parameters)',...
        string_dim(md.qmu_params,i)));
    fnames=fieldnames(md.qmu_params(i));
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['            %-' num2str(maxlen+1) 's: %s'],...
            fnames{j},any2str(md.qmu_params(i).(fnames{j}))));
    end
end

for i=1:numel(md.dakotaresults)
    disp(sprintf('         dakotaresults%s:  (information from dakota files)',...
        string_dim(md.dakotaresults,i)));
    fnames=fieldnames(md.dakotaresults(i));
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
            fnames{j},size(md.dakotaresults.(fnames{j})),class(md.dakotaresults.(fnames{j}))));
    end
end

if isempty(md.dakotain), disp(sprintf('         dakotain: N/A')); else disp(sprintf('         dakotain:    [%ix%i]    (can be accessed by typing md.dakotain)',size(md.dakotain)));end
if isempty(md.dakotaout), disp(sprintf('         dakotaout: N/A')); else disp(sprintf('         dakotaout:    [%ix%i]    (can be accessed by typing md.dakotaout)',size(md.dakotaout)));end
if isempty(md.dakotadat), disp(sprintf('         dakotadat: N/A')); else disp(sprintf('         dakotadat:    [%ix%i]    (can be accessed by typing md.dakotadat)',size(md.dakotadat)));end
disp(sprintf('         npart   : %i (number of partitions for semi-descrete qmu)',md.npart));
disp(sprintf('         numrifts: %i (number of rifts for semi-descrete qmu)',md.numrifts));
