function md=QueueJobPeekGeneric(md,executionpath)
%QUEUEJOBPEEKGENERIC - ...
%
%   Usage:
%      md=QueueJobPeekGeneric(md,executionpath)

disp('downloading error and output log files');

%download errlog and outlog from cluster
system(['scp ' md.cluster ':' executionpath '/' md.name '.*log ./']);

%read log files onto  fields
md.errlog=char(textread([md.name '.errlog'],'%s','delimiter','\n'));
md.outlog=char(textread([md.name '.outlog'],'%s','delimiter','\n'));

%cat those two files
disp(sprintf('\n\nerror log:\n\n'));
system(['cat ' md.name '.errlog']);

disp(sprintf('\n\noutput log:\n\n'));
system(['cat ' md.name '.outlog']);

%erase the log files
system(['rm -rf ' md.name '.outlog ' md.name '.errlog']);

%warn user
disp(sprintf('\n\nerror and output logs are saved in model fields for further checking'));
