/*!\file SealevelMasks.h
 * \brief: header file for SealevelMask object
 */

#ifndef _SEALEVELMASKS_H_
#define _SEALEVELMASKS_H_

/*Headers:*/

class SealevelMasks {

	public: 

		bool*       isiceonly;
		bool*       isfullyfloating;
		bool*       notfullygrounded;
		bool*       isoceanin; 
		
		/*SealevelMasks constructors, destructors :*/
		SealevelMasks(int localnel){
			/*allocate fields:*/
			this->isiceonly=xNew<bool>(localnel);
			this->isfullyfloating=xNew<bool>(localnel);
			this->notfullygrounded=xNew<bool>(localnel);
			this->isoceanin=xNew<bool>(localnel);
		};
		~SealevelMasks(){
			xDelete<bool>(this->isiceonly);
			xDelete<bool>(this->isfullyfloating);
			xDelete<bool>(this->notfullygrounded);
			xDelete<bool>(this->isoceanin);
		};
};
#endif  /* _SEALEVELMASKS_H_ */
