/* This software was developed by Bruce Hendrickson and Robert Leland   *
 * at Sandia National Laboratories under US Department of Energy        *
 * contract DE-AC04-76DP00789 and is copyrighted by Sandia Corporation. */

/**
 * NOTE: Under MSYS2 MinGW, we do not want to have to depend on the MSYS2 
 *		 runtime for our distributable packages. Unfortunately, sys/resource.h 
 *		 is not currently available for MinGW (standalone) targets under MSYS2. 
 *		 this further means that,
 *
 *			-I/mingw64/x86_64-w64-mingw32/include
 *
 *		 should be included in CFLAGS, and that,
 *
 *			-I/usr/include
 *
 *		 should be avoided.
 */
//#include   <sys/time.h>
//#include   <sys/resource.h>
#include   <time.h>

double    seconds()
{
    double    curtime;

// #ifdef RUSAGE_SELF

// /* This timer is faster and more robust (if it exists). */
//     struct rusage rusage;
//     int getrusage();
 
//     getrusage(RUSAGE_SELF, &rusage);
//     curtime = ((rusage.ru_utime.tv_sec + rusage.ru_stime.tv_sec) +
// 	    1.0e-6 * (rusage.ru_utime.tv_usec + rusage.ru_stime.tv_usec));

// #else

/* ANSI timer, but lower resolution & wraps around after ~36 minutes. */

    curtime = clock()/((double) CLOCKS_PER_SEC);

// #endif

    return (curtime);
}
