/*!\file MatToMPISerial.cpp
 * \brief gather a Petsc Mat matrix onto all cpus
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../petscincludes.h"
#include "../../../shared/shared.h"

void MatToMPISerial(double** poutmatrix,Mat matrix,ISSM_MPI_Comm comm){

	double* outmatrix=NULL;

	/*Call MatToSerial:*/
	MatToSerial(&outmatrix,matrix,comm);

	/*get matrix size: */
	MatGetSize(matrix,&M,&N);

	/*Allocate on cpus:*/
	if (my_rank!=0)outmatrix=xNew<double>(M*N);

	/*Broadcast:*/
	ISSM_MPI_Bcast(outmatrix,M*N,ISSM_MPI_PDOUBLE,0,comm);

	/*Assign output pointer:*/
	*poutmatrix=outmatrix;
}
