/*!\file ElementCoordinatesx
 * \brief: compute a vector xe,ye and ze of element centroid coordinates by
 * marching through all our elements.
 */

#include "./ElementCoordinatesx.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void ElementCoordinatesx( IssmDouble** pxe, IssmDouble** pye, IssmDouble** pze,Elements* elements,bool spherical) {

	/*figure out how many vertices we have: */
	int numberofelements=elements->NumberOfElements();

	Vector<IssmDouble>* vxe=new Vector<IssmDouble>(numberofelements);
	Vector<IssmDouble>* vye=new Vector<IssmDouble>(numberofelements);
	Vector<IssmDouble>* vze=new Vector<IssmDouble>(numberofelements);

	/*march through our elements: */
	for(Object* & object : elements->objects){
		Element* element=(Element*)object;
		element->ElementCoordinates(vxe,vye,vze,spherical);
	}

	/*Assemble*/
	vxe->Assemble();
	vye->Assemble();
	vze->Assemble();

	/*serialize: */
	IssmDouble* xe=vxe->ToMPISerial();
	IssmDouble* ye=vye->ToMPISerial();
	IssmDouble* ze=vze->ToMPISerial();

	/*Free ressources: */
	delete vxe;
	delete vye;
	delete vze;

	/*output: */
	if(pxe) *pxe=xe;
	else xDelete<IssmDouble>(xe);
	if(pye) *pye=ye;
	else xDelete<IssmDouble>(ye);
	if(pze) *pze=ze;
	else xDelete<IssmDouble>(ze);
}
