#!/bin/bash
#bamg has been developed by Frederic Hecht: http://www.ann.jussieu.fr/~hecht/
#available on http://www.ann.jussieu.fr/~hecht/ftp/bamg/

#Get number of cpus
NUMCPUS=$1;

#Bamg name
NAME=$(echo *.gz | sed 's/\.gz//g')

#Some cleanup
rm -rf install

#Create src and install directories
mkdir install

#uncompress
tar  -zxvf $NAME.gz

#move to install directory
mv bamg/* install/
rm -rf bamg

#patch Mesh2.h
cd install
patch Mesh2.h ../Mesh2.h.patch

#compile
source ../configure.sh
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
