/*!\file: oceantransport_core.cpp
 * \brief: core of the oceantransport solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void oceantransport_core(FemModel* femmodel){

	/*Start profiler*/
	femmodel->profiler->Start(OCEANTRANSPORTCORE);

	/*parameters: */
	int    numoutputs;
	bool   save_results;
	bool   dakota_analysis;
	int    solution_type;

	/*activate configuration*/
	femmodel->SetCurrentConfiguration(OceantransportAnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	if(VerboseSolution()) _printf0_("   computing ocean mass transport\n");

	femmodel->SetCurrentConfiguration(OceantransportAnalysisEnum);

	/*save current bottom pressures before updating:*/
	InputDuplicatex(femmodel,BottomPressureEnum,BottomPressureOldEnum);
	InputDuplicatex(femmodel,DslEnum,DslOldEnum);
	InputDuplicatex(femmodel,StrEnum,StrOldEnum);

	/*grab bottom pressures, dsl and str from OceantransportSpcbottompressure, OceantransportSpcdslEnum 
	 * and OceantransportSpcstrEnum  inputs in each element, assemble into a vector and feed to 
	 * InputUpdateFromSolutionx which will deal with accumulating such inputs:*/
	Vector<IssmDouble>*  ug  = NULL;
	GetSolutionFromInputsx(&ug,femmodel); 
	InputUpdateFromSolutionx(femmodel,ug); 

	delete ug;

	if(solution_type==OceantransportSolutionEnum)femmodel->RequestedDependentsx();

	/*profiler*/
	femmodel->profiler->Stop(OCEANTRANSPORTCORE);
}
