#include "./HydrologyTwsAnalysis.h"
#include <math.h>
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../classes/Inputs/TransientInput.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void HydrologyTwsAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void HydrologyTwsAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void HydrologyTwsAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel,bool isamr){/*{{{*/
	::CreateNodes(nodes,iomodel,HydrologyTwsAnalysisEnum,P1Enum);
}/*}}}*/
int  HydrologyTwsAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void HydrologyTwsAnalysis::UpdateElements(Elements* elements,Inputs* inputs,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	int nature=0;

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(inputs,i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*Plug inputs into element:*/
	iomodel->FetchDataToInput(inputs,elements,"md.hydrology.spcwatercolum", HydrologyTwsSpcEnum);

	/*Initialize sea level cumulated sea level loads :*/
	InputUpdateFromConstantx(inputs,elements,0.,AccumulatedDeltaTwsEnum);
	InputUpdateFromConstantx(inputs,elements,0.,OldAccumulatedDeltaTwsEnum);
	iomodel->FetchDataToInput(inputs,elements,"md.initialization.watercolumn",WatercolumnEnum);


}/*}}}*/
void HydrologyTwsAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

}/*}}}*/

/*Finite Element Analysis*/
void           HydrologyTwsAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
void           HydrologyTwsAnalysis::PreCore(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* HydrologyTwsAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* HydrologyTwsAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* HydrologyTwsAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* HydrologyTwsAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           HydrologyTwsAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/
	   _error_("not implemented yet");
}/*}}}*/
void           HydrologyTwsAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element*  element,int control_type,int control_interp,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           HydrologyTwsAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/

	/*Only update if on base*/
	if(!element->IsOnBase()) return;

	/*deal with logic of accumulating thickness if we are coupled to a 
	 * sea level core:*/
	int frequency,count,isgrd;
	element->FindParam(&isgrd,SolidearthSettingsGRDEnum);
	if(isgrd){
		element->FindParam(&frequency,SolidearthSettingsRunFrequencyEnum);
		element->FindParam(&count,SealevelchangeRunCountEnum);
	}	
	/*Fetch dof list and allocate solution vector*/
	int *doflist = NULL;
	element->GetDofListLocal(&doflist,NoneApproximationEnum,GsetEnum);

	int numnodes = element->GetNumberOfNodes();
	IssmDouble* watercolumn = xNew<IssmDouble>(numnodes);
	
	/*Use the dof list to index into the solution vector: */
	for(int i=0;i<numnodes;i++){
		watercolumn[i]=solution[doflist[i]];
		/*Check solution*/
		if(xIsNan<IssmDouble>(watercolumn[i])) _error_("NaN found in solution vector");
		if(xIsInf<IssmDouble>(watercolumn[i])) _error_("Inf found in solution vector");
	}
	element->AddBasalInput(WatercolumnEnum,watercolumn,element->GetElementType());

	xDelete<int>(doflist);
	xDelete<IssmDouble>(watercolumn);

	/*Get basal element*/
	int domaintype; element->FindParam(&domaintype,DomainTypeEnum);
	Element* basalelement=element;
	if(domaintype!=Domain2DhorizontalEnum) basalelement = element->SpawnBasalElement();

	/*Fetch number of nodes and dof for this finite element*/
	int numvertices = basalelement->GetNumberOfVertices();

	/*Now, we need to do some "processing"*/
	watercolumn  = xNew<IssmDouble>(numvertices);
	IssmDouble* oldwatercolumn      = xNew<IssmDouble>(numvertices);
	IssmDouble* cumdeltawatercolumn = xNew<IssmDouble>(numvertices);
	IssmDouble* oldcumdeltawatercolumn = xNew<IssmDouble>(numvertices);
	IssmDouble* deltawatercolumn = xNew<IssmDouble>(numvertices);

	/*Get previous base, tws, surfac and current sealevel and bed:*/
	basalelement->GetInputListOnVertices(&watercolumn[0],WatercolumnEnum);
	basalelement->GetInputListOnVertices(&oldwatercolumn[0],WaterColumnOldEnum);
	basalelement->GetInputListOnVertices(&cumdeltawatercolumn[0],AccumulatedDeltaTwsEnum);

	/*What is the delta tws forcing the sea-level change core: cumulated over time, hence the +=:*/
	if(isgrd){
		for(int i=0;i<numvertices;i++){
			cumdeltawatercolumn[i] += watercolumn[i]-oldwatercolumn[i];
		}
	}

	/*Add input to the element: */
	if(isgrd){
		element->AddBasalInput(AccumulatedDeltaTwsEnum,cumdeltawatercolumn,P1Enum);
		if(count==frequency){
			basalelement->GetInputListOnVertices(&oldcumdeltawatercolumn[0],OldAccumulatedDeltaTwsEnum);
			element->AddBasalInput(OldAccumulatedDeltaTwsEnum,cumdeltawatercolumn,P1Enum);
			for(int i=0;i<numvertices;i++)deltawatercolumn[i]=cumdeltawatercolumn[i]-oldcumdeltawatercolumn[i];
			element->AddBasalInput(DeltaTwsEnum,deltawatercolumn,P1Enum);
		}
	}

	/*Free ressources:*/
	xDelete<IssmDouble>(watercolumn);
	xDelete<IssmDouble>(deltawatercolumn);
	xDelete<IssmDouble>(cumdeltawatercolumn);
	xDelete<IssmDouble>(oldcumdeltawatercolumn);
	xDelete<IssmDouble>(oldwatercolumn);
	xDelete<int>(doflist);
	if(domaintype!=Domain2DhorizontalEnum){basalelement->DeleteMaterials(); delete basalelement;};
}/*}}}*/
void           HydrologyTwsAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
