#!/bin/bash
#
# Creates a local MS-MPI directory to be used for supplying header and library
# paths to ISSM configuration as well as the configuration of certain external
# packages.
#
# Local MS-MPI include and library paths are made available as environment
# variables LOCAL_MSMPI_INC and LOCAL_MSMPI_LIB, respectively (script can be
# sourced again).
#
# Paths may need to be modified in the future if Microsoft changes the
# directory structure and/or file naming in the MS-MPI package. Paths are
# based on Microsoft MPI v10.0,
#	https://www.microsoft.com/en-us/download/details.aspx?id=57467
#
LOCAL_MSMPI_ROOT="${ISSM_DIR}/MSMPI"
LOCAL_MSMPI_INC="${LOCAL_MSMPI_ROOT}/include"
LOCAL_MSMPI_LIB="${LOCAL_MSMPI_ROOT}/lib"
MSMPI_RUNTIME_LIB="/c/Windows/System32/msmpi.dll"
MSMPI_INC="/c/PROGRA~2/MICROS~2/MPI/Include"
MSMPI_LIB="${ISSM_DIR}/externalpackages/windows/MSMPI/lib"

cd ${ISSM_DIR}

if [ -d ${LOCAL_MSMPI_ROOT} ]; then
	echo "'${LOCAL_MSMPI_ROOT}' already exists!"
	echo "If you need to recreate local MS-MPI directory, remove '${LOCAL_MSMPI_ROOT}' and rerun this script."
else
	mkdir ${LOCAL_MSMPI_ROOT} ${LOCAL_MSMPI_INC} ${LOCAL_MSMPI_LIB}

	# Make SVN ignore local MS-MPI directory so that we do not accidentally
	# commit it
	svn propset svn:ignore ${LOCAL_MSMPI_ROOT} . &>/dev/null

	# Copy MS-MPI header files
	cp $MSMPI_INC/mpi.h ${LOCAL_MSMPI_INC}
	cp $MSMPI_INC/mpi.f90 ${LOCAL_MSMPI_INC}
	cp $MSMPI_INC/mpif.h ${LOCAL_MSMPI_INC}
	cp $MSMPI_INC/mpio.h ${LOCAL_MSMPI_INC}
	cp $MSMPI_INC/x64/mpifptr.h ${LOCAL_MSMPI_INC}

	# Copy MS-MPI libraries
	cp ${MSMPI_RUNTIME_LIB} ${LOCAL_MSMPI_LIB}

	cd ${LOCAL_MSMPI_LIB}

	# Create link to runtime library with MSYS prefix
	ln -s ./msmpi.dll ./msys-msmpi.dll

	# Create link to runtime library with lib prefix
	ln -s ./msmpi.dll ./libmsmpi.dll
fi
