%Test Name: SquareShelfConstrainedSampling
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md = md.sampling.setparameters(md,2e5,1);
md.sampling.seed = 100;
md.cluster=generic('name',oshostname(),'np',1);
md1=solve(md,'smp');
md.sampling.robin = 1;
md.sampling.beta = sqrt(md.sampling.tau^2*md.sampling.kappa(1)^2)/1.42*ones(md.mesh.numberofvertices,1);
md2=solve(md,'smp');

%Fields and tolerances to track changes
field_names     ={'Sample1','Sample2'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md1.results.SamplingSolution.Sample),...
    (md2.results.SamplingSolution.Sample),...
	};