%Test Name: SquareShelfConstrainedSamplingTransient
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md = md.sampling.setparameters(md,2e5,1);
md.sampling.seed = 100;
md.cluster=generic('name',oshostname(),'np',1);
md=solve(md,'smp');
  
md.sampling.phi = 0.5;
md = md.sampling.setparameters(md,2e5,1*sqrt(1-md.sampling.phi*md.sampling.phi));   
md.initialization.sample = md.results.SamplingSolution.Sample;
md.transient = md.transient.deactivateall();
md.transient.issampling = 1;
md.timestepping.time_step = 1;
md.timestepping.final_time = 5;
md.settings.output_frequency = 1; 
md=solve(md,'transient');

%Fields and tolerances to track changes
field_names     ={'Sample0','Sample1','Sample2','Sample3','Sample4','Sample5'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
    md.initialization.sample,...
    md.results.TransientSolution(1).Sample,...
    md.results.TransientSolution(2).Sample,...
    md.results.TransientSolution(3).Sample,...
    md.results.TransientSolution(4).Sample,...
    md.results.TransientSolution(5).Sample,...
	};