

/*----------------------------------------------------------*/
/*															*/
/*							SOL2BB							*/
/*															*/
/*----------------------------------------------------------*/
/*															*/
/*	Description:		convert a .sol(b) file into a .BB	*/
/*	Author:				Loic MARECHAL						*/
/*	Creation date:		jul 21 2004							*/
/*	Last modification:	nov 23 2005							*/
/*															*/
/*----------------------------------------------------------*/


/*----------------------------------------------------------*/
/* Includes													*/
/*----------------------------------------------------------*/

#include <libmesh4.h>
#include <string.h>


/*----------------------------------------------------------*/
/* Local defines											*/
/*----------------------------------------------------------*/

#define bb 1
#define BB 2


/*----------------------------------------------------------*/
/* Check args and copy each fields from infile to outfile	*/
/*----------------------------------------------------------*/

int main(int ArgCnt, char **ArgVec)
{
	int i, j, SolTyp=0, idx=0, OutTyp, siz;
	float *buf;
	char *InpNam, *OutNam, *TypStr;
	GmfMshSct *SolMsh;
	KwdSct *kwd;
	FILE *hdl;

	/* Parse command-line arguments */

	switch(ArgCnt)
	{
		case 1 :
		{
			printf("\nSOL2BB v1.0,   mar 30 2005,   written by Loic MARECHAL\n");
			printf(" Usage : sol2bb source_name.solb destination_name.BB support_element\n");
			printf(" where support_element is : ver | edg | qad | tet | pen | hex\n\n");
			return(1);
		}break;

		case 2 : case 3 :
		{
			fprintf(stderr,"Wrong number of arguments.\n");
			return(1);
		}break;

		case 4 :
		{
			InpNam = *++ArgVec;
			OutNam = *++ArgVec;
			TypStr = *++ArgVec;

			if(strstr(TypStr, "ver"))
				SolTyp = GmfSolAtVertices;
			else if(strstr(TypStr, "edg"))
				SolTyp = GmfSolAtEdges;
			else if(strstr(TypStr, "tri"))
				SolTyp = GmfSolAtTriangles;
			else if(strstr(TypStr, "qad"))
				SolTyp = GmfSolAtQuadrilaterals;
			else if(strstr(TypStr, "tet"))
				SolTyp = GmfSolAtTetrahedra;
			else if(strstr(TypStr, "pen"))
				SolTyp = GmfSolAtPentahedra;
			else if(strstr(TypStr, "hex"))
				SolTyp = GmfSolAtHexahedra;
			else
			{
				fprintf(stderr,"Wrong type of element : %s\n", TypStr);
				return(1);
			}
		}break;
	}

	if(strstr(OutNam, ".bb"))
		OutTyp = bb;
	else if(strstr(OutNam, ".BB"))
		OutTyp = BB;
	else
	{
		fprintf(stderr,"Source of error : BB2SOL / OPEN_BB\n");
		fprintf(stderr,"%s is not a .bb nor a .BB file\n", InpNam);
		return(1);
	}

	/* Open the .solb file for reading */

	if(!(SolMsh = GmfOpenMesh(InpNam, GmfRead)))
	{
		fprintf(stderr,"Cannot open %s\n", InpNam);
		return(1);
	}

	/* Check if the sol contains the required kw */

	kwd = &SolMsh->KwdTab[ SolTyp ];

	if(!kwd->NmbLin)
	{
		fprintf(stderr,"No such element in sol file.\n");
		return(1);
	}

	/* Alocate the whole buffer and read the solution */

	if(!(buf = malloc(kwd->NmbLin * kwd->SolSiz * sizeof(float))))
	{
		fprintf(stderr,"Malloc failure.\n");
		return(1);
	}

	if(!GmfReadField(SolMsh, SolTyp, buf, NULL))
	{
		fprintf(stderr,"Read error.\n");
		return(1);
	}

	/* Create the bb file and write the header */

	if(!(hdl = fopen(OutNam, "wb")))
	{
		fprintf(stderr,"Cannot open %s\n", OutNam);
		return(1);
	}

	if(OutTyp == bb)
	{
		if(kwd->TypTab[0] == GmfSca)
			siz = 1;
		else if(kwd->TypTab[0] == GmfVec)
			siz = SolMsh->dim;
		else if(kwd->TypTab[0] == GmfSymMat)
			siz = SolMsh->dim * (SolMsh->dim + 1) / 2;
		else if(kwd->TypTab[0] == GmfMat)
			siz = SolMsh->dim * SolMsh->dim;

		if(SolTyp == GmfSolAtVertices)
			fprintf(hdl, "%d %d %d 2\n", SolMsh->dim, siz, kwd->NmbLin);
		else
			fprintf(hdl, "%d %d %d 1\n", SolMsh->dim, siz, kwd->NmbLin);
	}
	else
	{
		fprintf(hdl, "%d %d ", SolMsh->dim, kwd->NmbTyp);

		for(i=0;i<kwd->NmbTyp;i++)
		{
			if(kwd->TypTab[i] == GmfSca)
				fprintf(hdl, "1 ");
			else if(kwd->TypTab[i] == GmfVec)
				fprintf(hdl, "%d ", SolMsh->dim);
			else if(kwd->TypTab[i] == GmfSymMat)
				fprintf(hdl, "%d ", SolMsh->dim * (SolMsh->dim + 1) / 2);
			else if(kwd->TypTab[i] == GmfMat)
				fprintf(hdl, "%d ", SolMsh->dim * SolMsh->dim);
			else
			{
				fprintf(stderr,"Wrong solution type : %d\n", kwd->TypTab[i]);
				return(1);
			}
		}

		if(SolTyp == GmfSolAtVertices)
			fprintf(hdl, "%d %d\n", kwd->NmbLin, 2);
		else
			fprintf(hdl, "%d %d\n", kwd->NmbLin, 1);
	}

	/* Then write the solutions */

	for(i=0;i<kwd->NmbLin; i++)
	{
		for(j=0;j<kwd->SolSiz;j++)
			fprintf(hdl, "%g ", buf[ idx++ ]);

		fprintf(hdl, "\n");
	}

	if(SolMsh->iter)
		fprintf(hdl, "%d\n", SolMsh->iter);

	if(SolMsh->time)
		fprintf(hdl, "%g\n", SolMsh->time);

	/* Free and close everything */

	free(buf);
	fclose(hdl);

	if(!GmfCloseMesh(SolMsh))
		return(1);

	return(0);
}
