

/*----------------------------------------------------------*/
/*															*/
/*							BB2SOL							*/
/*															*/
/*----------------------------------------------------------*/
/*															*/
/*	Description:		convert a .bb or .BB file in .sol	*/
/*	Author:				Loic MARECHAL						*/
/*	Creation date:		mar  8 2004							*/
/*	Last modification:	nov 23 2005							*/
/*															*/
/*----------------------------------------------------------*/


/*----------------------------------------------------------*/
/* Includes													*/
/*----------------------------------------------------------*/

#include <libmesh4.h>
#include <string.h>


/*----------------------------------------------------------*/
/* Local defines											*/
/*----------------------------------------------------------*/

#define bb 1
#define BB 2


/*----------------------------------------------------------*/
/* Check args and copy each fields from infile to outfile	*/
/*----------------------------------------------------------*/

main(int ArgCnt, char **ArgVec)
{
	int i, j, NmbLin, InpTyp, SolEleTyp, SolSiz=0, dim, idx=0;
	float *buf;
	char *InpNam, *OutNam, *TypStr;
	GmfMshSct *SolMsh;
	KwdSct *kwd;
	FILE *hdl;

	/* Parse command-line arguments */

	switch(ArgCnt)
	{
		case 1 :
		{
			printf("\nBB2SOL v1.1,   mar 30 2005,   written by Loic MARECHAL\n");
			printf(" Usage : bb2sol source_name.bb destination_name.solb support_element\n");
			printf(" where support_element is : ver | edg | qad | tet | pen | hex\n\n");
			return(0);
		}break;

		case 2 : case 3 :
		{
			fprintf(stderr,"Wrong number of arguments.\n");
			return(1);
		}break;

		case 4 :
		{
			InpNam = *++ArgVec;
			OutNam = *++ArgVec;
			TypStr = *++ArgVec;

			if(strstr(TypStr, "ver"))
				SolEleTyp = GmfSolAtVertices;
			else if(strstr(TypStr, "edg"))
				SolEleTyp = GmfSolAtEdges;
			else if(strstr(TypStr, "tri"))
				SolEleTyp = GmfSolAtTriangles;
			else if(strstr(TypStr, "qad"))
				SolEleTyp = GmfSolAtQuadrilaterals;
			else if(strstr(TypStr, "tet"))
				SolEleTyp = GmfSolAtTetrahedra;
			else if(strstr(TypStr, "pen"))
				SolEleTyp = GmfSolAtPentahedra;
			else if(strstr(TypStr, "hex"))
				SolEleTyp = GmfSolAtHexahedra;
			else
			{
				fprintf(stderr,"Wrong type of element : %s\n", TypStr);
				return(1);
			}
		}break;
	}

	/* Open the .bb or .BB file for reading */

	if(strstr(InpNam, ".bb"))
		InpTyp = bb;
	else if(strstr(InpNam, ".BB"))
		InpTyp = BB;
	else
	{
		fprintf(stderr,"Source of error : BB2SOL / OPEN_BB\n");
		fprintf(stderr,"%s is not a .bb nor a .BB file\n", InpNam);
		return(1);
	}

	if(!(hdl = fopen(InpNam, "r")))
	{
		fprintf(stderr,"Source of error : BB2SOL / OPEN_BB\n");
		fprintf(stderr,"Cannot open %s\n", InpNam);
		return(1);
	}

	/* Read and check the dimension */

	fscanf(hdl, "%d", &dim);

	if( (dim != 3) && (dim != 2) )
	{
		fprintf(stderr,"Source of error : BB2SOL / READ_BB\n");
		fprintf(stderr,"Wrong dimension : %d\n", dim);
		return(1);
	}

	/* Create a .sol file */

	if(!(SolMsh = GmfOpenMesh(OutNam, GmfWrite, dim)))
	{
		fprintf(stderr,"Source of error : BB2SOL / OPEN_MESH\n");
		fprintf(stderr,"Cannot open %s\n", OutNam);
		return(1);
	}

	kwd = &SolMsh->KwdTab[ SolEleTyp ];

	/* bb case */

	if(InpTyp == bb)
	{
		kwd->NmbTyp = 1;

		fscanf(hdl, "%d", &InpTyp);

		if(InpTyp == 1)
			kwd->TypTab[0] = GmfSca;
		else if(InpTyp == dim)
			kwd->TypTab[0] = GmfVec;
		else if(InpTyp == (dim * (dim + 1)) / 2)
			kwd->TypTab[0] = GmfSymMat;
		else if(InpTyp == dim * dim)
			kwd->TypTab[0] = GmfMat;
		else
		{
			fprintf(stderr,"Source of error : BB2SOL / READ_BB\n");
			fprintf(stderr,"Wrong solution size : %d\n", InpTyp);
			return(1);
		}
	}
	else /* BB case */
	{
		/* Read and check the number of types */

		fscanf(hdl, "%d", &kwd->NmbTyp);

		if( (kwd->NmbTyp < 1) || (kwd->NmbTyp > GmfMaxTyp) )
		{
			fprintf(stderr,"Source of error : BB2SOL / READ_BB\n");
			fprintf(stderr,"Wrong number of types : %d\n", kwd->NmbTyp);
			return(1);
		}

		/* Read each types, store them in the sol header */

		for(i=0;i<kwd->NmbTyp;i++)
		{
			fscanf(hdl, "%d", &j);

			if(j == 1)
				kwd->TypTab[i] = GmfSca;
			else if( (j == 2) && (dim == 2) )
				kwd->TypTab[i] = GmfVec;
			else if( (j == 3) && (dim == 2) )
				kwd->TypTab[i] = GmfSymMat;
			else if( (j == 3) && (dim == 3) )
				kwd->TypTab[i] = GmfVec;
			else if( (j == 4) && (dim == 2) )
				kwd->TypTab[i] = GmfMat;
			else if( (j == 6) && (dim == 3) )
				kwd->TypTab[i] = GmfSymMat;
			else if( (j == 9) && (dim == 3) )
				kwd->TypTab[i] = GmfMat;
			else
			{
				fprintf(stderr,"Source of error : BB2SOL / READ_BB\n");
				fprintf(stderr,"Wrong solution type : %d\n", j);
				return(1);
			}
		}
	}

	/* Read and check the number of solutions */

	fscanf(hdl, "%d", &NmbLin);

	if(NmbLin < 1)
	{
		fprintf(stderr,"Source of error : BB2SOL / READ_BB\n");
		fprintf(stderr,"Wrong number of solutions : %d\n", NmbLin);
		return(1);
	}

	/* Jump over the solution's reference element */

	fscanf(hdl, "%d", &i);

	/* Compute the solution's size */

	for(i=0;i<kwd->NmbTyp;i++)
		switch(kwd->TypTab[i])
		{
			case GmfSca : SolSiz++;break;
			case GmfVec : SolSiz += dim;break;
			case GmfSymMat : SolSiz += (dim * (dim+1)) / 2;break;
			case GmfMat : SolSiz += dim * dim;break;
		}

	/* Start reading the solutions */

	if(!(buf = malloc(NmbLin * SolSiz * sizeof(float))))
		return(0);

	for(i=1;i<=NmbLin;i++)
		for(j=0;j<SolSiz;j++)
			fscanf(hdl, "%g", &buf[ idx++ ]);

	/* read the optional time and iter ending information */

	fscanf(hdl, "%d %g", &SolMsh->iter, &SolMsh->time);

	fclose(hdl);

	GmfWriteField(SolMsh, SolEleTyp, NmbLin, buf, NULL);

	if(!GmfCloseMesh(SolMsh))
		return(1);

	return(0);
}
