

/*----------------------------------------------------------*/
/*															*/
/*				TEST UTILISANT LA LIBPARALLEL V2.0			*/
/*															*/
/*----------------------------------------------------------*/
/*															*/
/*	Description:		calcul de v3 = f(v1) + g(v2)		*/
/*	Author:				Loic MARECHAL						*/
/*	Creation date:		apr 22 2008							*/
/*	Last modification:	apr 22 2008							*/
/*															*/
/*----------------------------------------------------------*/


/*----------------------------------------------------------*/
/* Includes													*/
/*----------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include "libparallel2.h"


/*----------------------------------------------------------*/
/* Defines													*/
/*----------------------------------------------------------*/

#define size 10000000


/*----------------------------------------------------------*/
/* Structures' prototypes									*/
/*----------------------------------------------------------*/

typedef struct
{
	double *vec1, *vec2, *vec3;
}AddArgSct;


/*----------------------------------------------------------*/
/* Procedure appelee en // calculant v3 = f(v1) + g(v2)		*/
/* Les arguments de la procedure sont imposes :				*/
/* BegIdx : indice du debut de la boucle					*/
/* EndIdx : indice de la fin de la boucle					*/
/* PthIdx : indice du thread executant cette boucle (info)	*/
/* arg    : pointeur sur une structure argument				*/
/*          de l'utilisateur								*/
/*----------------------------------------------------------*/

void AddVec(int BegIdx, int EndIdx, int PthIdx, AddArgSct *arg)
{
	int i;
	double *vec1, *vec2, *vec3;
printf("debut %d  fin %d\n",BegIdx,EndIdx)
	/* Recuperation des arguments dans des variables locales */

	vec1 = arg->vec1;
	vec2 = arg->vec2;
	vec3 = arg->vec3;

	/* Calcul de v3 = f(v1) + g(v2) sur les indices donnes en arguments */

	for(i=BegIdx; i<=EndIdx; i++)
		vec3[i] = exp(log(acos(cos(vec1[i]+1.)))) + exp(log(acos(cos(vec2[i]+2.))));
}


/*----------------------------------------------------------*/
/* Le main lit le nombre de CPU a utiliser en argument		*/
/*----------------------------------------------------------*/

int main(int ArgCnt, char **ArgVec)
{
	int i, NmbCpu, TypIdx, LibParIdx;
	float acc;
	double *vec1, *vec2, *vec3;
	AddArgSct arg;

	/* Lecture de la ligne de commande */

	if(ArgCnt != 2)
	{
		puts("testlibparallel2 n : n etant le nombre de threads a lancer.\n");
		exit(0);
	}

	NmbCpu = atoi(*++ArgVec);

	/* Allocation et initialisation des trois vecteurs */

	vec1 = malloc(size * sizeof(double));
	vec2 = malloc(size * sizeof(double));
	vec3 = malloc(size * sizeof(double));

	for(i=0;i<size;i++)
	{
		vec1[i] = i;
		vec2[i] = i*2;
		vec3[i] = 0;
	}

	/* Construction de la structure d'arguments : on donne des pointeurs sur les vecteurs */

	arg.vec1 = vec1;
	arg.vec2 = vec2;
	arg.vec3 = vec3;

	/* Initialisation de la libparallel : si la valeur de retour est 0, c'est un echec, sinon
		une etiquette sur cette instanciation de la librairie. Cette valeur sera a fournir a
		tout appel de fonction */

	if(!(LibParIdx = InitParallel(NmbCpu)))
	{
		puts("Erreur dans l'initialisation de la libparallel.");
		exit(1);
	}

	/* Creation d'un type de donnee : fournir le numero de librairie et la taille du vecteur.
		Le retour est 0 pour un echec ou une etiquette de type a fournir pour lancer des boucles
		parallelisees sur ce type de donnee */

	if(!(TypIdx = NewType(LibParIdx, size)))
	{
		puts("Erreur dans la creation du type de donnee.");
		exit(1);
	}

	/* Lancement de la boucle de calcul v3 = f(v1) + g(v2) avec le parametres suivants :
		-numero de librairie ouverte
		-numero de type de donnee
		-numero de type de donnee de dependance (0 si il n'y a pas de dependance)
		-pointeur sur la routine a lancer en parallel
		-pointeur sur la structure d'argument lue par cette routine
		Le retour est un nombre reel valant 0 en cas d'echec ou une valeur d'acceleration
		due au calcul parallel en cas de succes. Plus le facteur d'acceleration est proche
		du nombre de CPU donnee en initialisation, meilleur est l'implementation */

	if(!(acc = LaunchParallel(LibParIdx, TypIdx, 0, (void *)AddVec, (void *)&arg)))
	{
		puts("Erreur dans le lancement de la routine parallele.");
		exit(1);
	}

	printf("Taux d'acceleration de la boucle = %g\n", acc);

	/* Arret et desallocation de cette instanciation de la libparallel */

	StopParallel(LibParIdx);

	return(0);
}
