/*
 *  memory reallocation / Geom
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int zaldy3(pSurfMesh sm,int code) {
  pGeomSupp   ptrn;
  pGeomtge    ptrt;
  pMetric     pm;
  int         j,k,ntsize,nvsize;

  E_put("zaldy3");
  switch(code) {
  case 1:  /* normals */
    nvsize = (int)(1.3 * sm->nvmax);
    ptrn = (pGeomSupp)M_realloc(sm->geom,(1+nvsize) * sizeof(GeomSupp),"zaldy3");
    if ( !ptrn ) {
      yerr.coderr = 0032;
      return(0);
    }
    sm->geom = ptrn;
    for (j=sm->nvmax; j<nvsize; j++) {
      sm->geom[j].vn[0] = sm->geom[j].vn[1] = sm->geom[j].vn[2] = 0.;
      sm->geom[j].gap   = 1.;
      sm->geom[j].new   = 0;
    }
    sm->nvmax = nvsize;
    yerr.inderr[0] = sm->nvmax;
    if ( imprim < -4 )  primsg(1040);
    break;
  
  case 2:  /* tangents */
    ntsize = (int)(1.3 * sm->ntmax);
    ptrt = (pGeomtge)M_realloc(sm->tgte,(1+ntsize) * sizeof(Geomtge),"zaldy3");
    if ( !ptrt ) {
      yerr.coderr = 0033;
      return(0);
    }
    sm->tgte = ptrt;
    for (j=sm->ntmax; j<ntsize; j++) {
      sm->tgte[j].t[0] = sm->tgte[j].t[1] = sm->tgte[j].t[2] = 0.;
    }
    sm->ntmax = ntsize;
    yerr.inderr[0] = sm->ntmax;
    break;
  
  case 3:  /* metric */
    sm->metric = (pMetric)M_calloc((sm->npmax+1),sizeof(Metric),"zaldy3");
    if ( !sm->metric ) {
      prierr(ERR,0002);
      return(0);
    }
    for (k=0; k<=sm->npmax; k++) {
      pm = &sm->metric[k];
      pm->k1 = pm->k2 = -1.0;
    }
    break;
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
