/*
 *  dynamic memory allocation for hash table
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int zaldy2(int npmax) {
  pHashtable  pht;
  int         k,nhold;

  /* default */
  E_put("zaldy2");
  if ( hash == NULL ) {
    /* allocate hash table */
    nhmax = max(3.71 * npmax,NHMAX);
    hash = (pHashtable)M_calloc(nhmax+2,sizeof(Hashtable),"zaldy2");
    if ( !hash ) {
      yerr.coderr = 0031;
      return(0);
    }

    /* init hash table size */
    hsize = 2 * npmax;
    hnext = hsize;

    /* init links */
    for (k=hsize; k<nhmax; k++)
      hash[k].nxt = k+1;
  }
  
  /* reallocate */
  else {
    nhold = nhmax;
    nhmax = nhmax / 2 * 3;
    pht = (pHashtable)M_realloc(hash,sizeof(Hashtable)*(nhmax+2),"zaldy2");
    if ( pht == NULL ) {
      yerr.lerror = TRUE;
      yerr.coderr = 0030;
      return(0);
    }
    hash = pht;
    hnext = nhold+1;
    for (k=hnext; k<nhmax; k++) {
      hash[k].min = 0;
      hash[k].nxt = k+1;
    }
    /* hash[nhmax-1].nxt = 0; */
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
