#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define VLIMIT   125000

int zaldy1(int nemax,int npmax,int nvmax,int memory,pSurfMesh sm,int choix) {
  int million = 1048576L;

  /* default */
  E_put("zaldy1");

  /* set default memory requirements */
  /* blindage / DS
  if ( npmax > VLIMIT ) {
    fprintf(stdout," ## Too many nodes (%d) / evaluation (%d). Sorry.\n",
            npmax,VLIMIT);
    fprintf(stdout,"    Please contact the author.\n");
    exit(1);    
  }
  */
  if ( memory < 0 ) {
    if ( !(sm->type & M_QUADS) && (choix <= 0  || choix == 9) ) {
      sm->nemax = max(nemax,NEMAX);
      sm->npmax = max(npmax,NPMAX);
      sm->nvmax = max(nvmax,NVMAX);
      sm->ntmax = max((int)(0.2*npmax),NTMAX);
    }
    else if ( choix != 4 ) {
      sm->nemax = max((int)(1.5*nemax),NEMAX);
      sm->npmax = max((int)(1.5*npmax),NPMAX);
      sm->nvmax = max((int)(1.5*nvmax),NVMAX);
      sm->ntmax = max((int)(0.2*npmax),NTMAX);
    }
    /* uniform triangle subdivision */
    else {
      int  n,m;
      n = opts.iter+1;
      m = n*(n+1)/2 + n-2;
      sm->nemax = 10+(n*n*nemax);
      sm->npmax = 10+((m+3)*nemax);
      sm->nvmax = 10+(m*nvmax);
      sm->ntmax = 10+(int)(0.2*m*npmax);
    }
  }
  else {
    int bytes = sizeof(struct spoint) \
              + sizeof(struct metric) \
              + 2   * sizeof(struct striangle) \
              + 1.5 * sizeof(struct geomsupp) \
              + 0.2 * sizeof(struct geomtge) \
              + 3.7 * sizeof(struct shashtab);

    sm->npmax = (int)((double)memory / bytes * million);
    sm->npmax = max(sm->npmax,npmax);
    sm->nemax = max(2 * sm->npmax,nemax);
    sm->nvmax = 1.5 * sm->npmax;
    sm->ntmax = 0.2 * sm->npmax;
  }

  /* allocate memory for triangles */
  if ( choix != 4 ) {
    do {
      sm->tria = (pTriangle)M_calloc(sm->nemax+1,sizeof(Triangle),"zaldy1");
      if ( !sm->tria ) {
        sm->nemax *= 0.8;
        sm->npmax *= 0.8;
        sm->nvmax *= 0.8;
        sm->ntmax *= 0.8;
      }
    }
    while ( !sm->tria && sm->nemax > nemax );
  }
  else
    sm->tria = (pTriangle)M_calloc(sm->nemax+1,sizeof(Triangle),"zaldy1");
  
  if ( !sm->tria ) {
    yerr.coderr = 0002;
    return(0);
  }

  /* allocate memory for points */
  sm->point = (pPoint)M_calloc(sm->npmax+1,sizeof(Point),"zaldy1");
  if ( !sm->point ) {
    yerr.coderr = 0002;
    return(0);
  }

  /* allocate memory for geometry */
  sm->geom = (pGeomSupp)M_calloc(sm->nvmax+1,sizeof(GeomSupp),"zaldy1");
  if ( !sm->geom ) {
    yerr.coderr = 0002;
    return(0);
  }
  sm->tgte = (pGeomtge)M_calloc(sm->ntmax+1,sizeof(Geomtge),"zaldy1");
  if ( !sm->tgte ) {
    yerr.coderr = 0002;
    return(0);
  }

  /* allocate memory for metric */
  if ( abs(choix) == 2 ) {
    E_pop();
    return(1);
  }

  sm->edge = 0;

  E_pop();
  return(1);
}
