#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  QMAX   0.9
#define  QMIN   0.05


int yamsq(pSurfMesh sm) {
  pStack     stack;
  pTriangle  pt;
  float      declic,decinc;
  int        k,is,it,alert,maxtou,nmq,nmv,nad,na,nq,nqi;

  /* default */
  E_put("yamsq");
  if ( abs(imprim) > 3 )  primsg(4027);
      
  if ( sm->np > sm->npfixe )
    taspoi(sm);

  nmq = nad = nmv = 0;
  maxtou = 3;
  it     = 1;
  declic = QMAX;
  decinc = (QMAX - QMIN) / maxtou;

  /* stack alloc */
  stack = stinit(sm->ne);

  /* stage 1: mixed mesh */
  if ( imprim < -4 )  primsg(4013);

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->flag1 = 0;
    pt->flag2 = 10;
  }

  for (it=0; it<=maxtou; it++) {
    nq = 0;
    do {
      is  = stqueue(sm,stack,it==0);
      nqi = 0;
      if ( is ) {
        nqi  = stscan(sm,stack,declic);
        nq  += nqi;
      }
    }
    while ( nqi );
    if ( nq && abs(imprim) > 2 ) {
      yerr.inderr[0] = is;
      yerr.inderr[1] = nq;
      primsg(2014);
    }
    nmq    += nq;
    declic -= decinc;
  }

  if ( nmq && abs(imprim) < 3 ) {
    yerr.inderr[0] = sm->ne - 2*nmq;
    yerr.inderr[1] = nmq;
    primsg(2014);
  }
  M_free(stack->t);
  M_free(stack);

  /* stage 2 */
  if ( imprim < -4 )  primsg(4014);
  na  = analar_q(sm,&alert);
  nmq = cassar_q(sm);
  if ( sm->type & M_SMOOTH ) {
    if ( abs(imprim) > 3 )  primsg(4028);
    declic = 0.95;
    if ( !updtop_q(sm) )  return(0);
    nmv = optpo1_q(sm,declic);
  }
  if ( nmv && abs(imprim) < 3 ) {
    yerr.inderr[0] = nmv;
    primsg(4008);
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
