#include <assert.h>

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern ubyte ecp;


int yams8(pSurfMesh sm,char *fileout,int absopt) {
  int     ret;
  char   *ptr,data[256];

  /* default */
  E_put("yams8");
  if ( fileout == NULL ) {
    fileout = (char *)malloc(128*sizeof(char));
    assert(fileout);
    strcpy(fileout,sm->infile);
    ptr = (char *)strstr(fileout,".mesh");
    if ( ptr ) *ptr = '\0';
    /* remove extension */
    ptr = (char *)strstr(fileout,".d");
    if ( ptr && strlen(ptr) == 2 ) *ptr = '\0';
    if ( sm->type & M_BINARY )
      strcat(fileout,".d.meshb");
    else 
      strcat(fileout,".d.mesh");
  }
  ret = 1;

  if ( imprim ) fprintf(stdout,"  -- WRITING DATA FILE %s\n",fileout);
  if ( sm->nq )
    ret = saveQuadMesh(sm,fileout);
  else {
    ret = saveMesh(sm,fileout);
    //if ( ecp )
    //  ret = outEcp(sm,fileout);
  }
  if ( !ret ) {
    prierr(WAR,yerr.coderr);
    return(0);
  }

  if ( sm->type & M_METRIC ) {
    strcpy(data,fileout);
    ptr = (char *)strstr(data,".mesh");
    if ( ptr )  *ptr = '\0';
    if ( sm->type & M_BINARY )
      strcat(data,".solb");
    else 
      strcat(data,".sol");

    ret = saveSol(sm,data);
    if ( !ret ) {
      prierr(WAR,yerr.coderr);
      return(0);
    }
  }

  if ( imprim ) fprintf(stdout,"  -- WRITING COMPLETED\n");

  E_pop();
  return(1);
}
