#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define R_EDGE    10
#define R_PLUS    2
#define R_MINUS   3

#define EPSL       1.e-4


int levelset(pSurfMesh sm) {
  pTriangle    pt,pt1,pt2;
  pPoint       ppt,pa,pb,pc;
  pHashtable   pht;
  double       dd,ll,hhmin,eps,ux,uy,uz;
  float        n[3];
  int          i,k,ineg,cfg,kk[3],ii,nbe,nemax;
  ubyte        i1,i2,filter;

  E_put("levelset");
  ++sm->mark;
  filter = 0;

  /* remove old tags */
  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
		ppt->size -= opts.iso;
    if ( ppt->ref == R_EDGE ) {
      ppt->ref = 0;
      ppt->tag = M_NOTAG;
    }
  }

  nbe = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    ineg = 0;
    for (i=0; i<3; i++) {
      ppt   = &sm->point[ pt->v[i] ];
      ineg += ( ppt->size < -EPSL );
      if ( pt->edg[i] == R_EDGE ) {
        pt->edg[i] = 0;
        pt->tag[i] = M_NOTAG;
        i1 = idir[i+1];
        i2 = idir[i+2];
        ppt = &sm->point[pt->v[i1]];
        ppt->tag = M_NOTAG;
        ppt = &sm->point[pt->v[i2]];
        ppt->tag = M_NOTAG;
      }
    }
    if ( !ineg )          pt->ref = R_PLUS;
    else if ( ineg > 2 )  pt->ref = R_MINUS;
    else {
      nbe ++;
      pt->ref = 0;
    }
  }
  if ( !nbe ) {
    E_pop();
    return(1);
  }
  else if ( sm->ne+nbe >= sm->nemax ) {
    prierr(ERR,0002);
    return(0);
  }

  /* reset hash table */
  for (k=1; k<nhmax; k++)
    hash[k].ind = hash[k].elt = 0;

  /* split elements */
  hhmin = opts.hmin * opts.hmin;
  nemax = sm->ne;
  for (k=1; k<=nemax; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] || pt->ref )  continue;
		
    /* store edge vertices */
    cfg = 0;
    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      kk[i] = ii = 0;
      pa = &sm->point[ pt->v[i1] ];
      pb = &sm->point[ pt->v[i2] ];
      pc = &sm->point[ pt->v[i] ];

      if ( fabs(pa->size) <= EPSL ) {
        if ( !pa->ref ) //<= R_EDGE )
          pa->ref = pt->edg[i] ? pt->edg[i] : R_EDGE;
        pa->tag  = M_RIDGE_REF;
        pa->size = 0.0;
      }
      if ( fabs(pb->size) <= EPSL ) {
        if ( !pb->ref ) // <= R_EDGE )
          pb->ref = pt->edg[i] ? pt->edg[i] : R_EDGE;
        pb->tag  = M_RIDGE_REF;
        pb->size = 0.0;
      }

      if ( pa->size*pb->size > 0.0 )  continue;

      if ( fabs(pa->size) < EPSL && fabs(pb->size) < EPSL ) {
        pt->tag[i] = M_RIDGE_REF;
        pt->edg[i] = R_EDGE;
        pt->ref    = pc->size < 0 ? R_MINUS : R_PLUS;
        if ( pt->adj[i] < k ) {
          pt1 = &sm->tria[pt->adj[i]];
          pt1->tag[pt->voy[i]] = M_RIDGE_REF;
          pt1->edg[pt->voy[i]] = R_EDGE;
          pt1->ref = pt->ref == R_MINUS ? R_PLUS : R_MINUS;
        }
        continue;
      }
      else if ( fabs(pa->size) < EPSL || fabs(pb->size) < EPSL )
        continue;

      /* splitting */
      pht = hedge(pt->v[i1],pt->v[i2],&kk[i],&ii);
      if ( !kk[i] ) {
        pht->elt = ++sm->np;
        kk[i] = sm->np;
        ppt   = &sm->point[sm->np];

        /* filtering */
        if ( filter ) {
          ux = pb->c[0] - pa->c[0];
          uy = pb->c[1] - pa->c[1];
          uz = pb->c[2] - pa->c[2];
          ll = (ux*ux + uy*uy + uz*uz);
          if ( ll < 4.0*hhmin ) {
            dd = 4.0*hhmin;
          }
          else {
            eps = hhmin / ll;
            dd  = pa->size / (pa->size - pb->size);
            dd  = max(eps,min(dd,1.0-eps));
          }
        }
        else {
          dd  = pa->size / (pa->size - pb->size);
        }
        ppt->c[0] = pa->c[0] + dd * (pb->c[0]-pa->c[0]);
        ppt->c[1] = pa->c[1] + dd * (pb->c[1]-pa->c[1]);
        ppt->c[2] = pa->c[2] + dd * (pb->c[2]-pa->c[2]);

        ppt->ref  = pt->edg[i] ? pt->edg[i] : R_EDGE;
        ppt->tag  = M_RIDGE_REF;
        ppt->color = sm->mark;
        ppt->size = 0.0;
      }

      cfg |= 1 << i;
    }
	
    if ( !cfg ) {
      if ( fabs(pa->size) > EPSL )
        pt->ref = pa->size < 0 ? R_MINUS : R_PLUS;
      else if ( fabs(pb->size) > EPSL )
        pt->ref = pb->size < 0 ? R_MINUS : R_PLUS;
      else if ( fabs(pc->size) > EPSL )
        pt->ref = pc->size < 0 ? R_MINUS : R_PLUS;

      continue;
    }

    /* create elements */
    pt1 = &sm->tria[++sm->ne];
    pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));
    switch (cfg) {
      case 1:
        pt->v[2]   = kk[0];
        pt1->v[1]  = kk[0];
        pt->tag[1] = pt1->tag[2] = M_RIDGE_REF;
        pt->edg[1] = pt1->edg[2] = R_EDGE;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);

        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        if ( pc->size < 0.0 ) {
          pt->ref  = R_PLUS;
          pt1->ref = R_MINUS;
        }
        else {
          pt->ref  = R_MINUS;
          pt1->ref = R_PLUS;
        }
      break;

      case 2:
        pt->v[2]   = kk[1];
        pt1->v[0]  = kk[1];
        pt->tag[0] = pt1->tag[2] = M_RIDGE_REF;
        pt->edg[0] = pt1->edg[2] = R_EDGE;
        pt->ref = pt1->ref = 200;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);

        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        if ( pc->size < 0.0 ) {
          pt->ref  = R_PLUS;
          pt1->ref = R_MINUS;
        }
        else {
          pt->ref  = R_MINUS;
          pt1->ref = R_PLUS;
        }
      break;

      case 4:
        pt->v[1]   = kk[2];
        pt1->v[0]  = kk[2];
        pt->tag[0] = pt1->tag[1] = M_RIDGE_REF;
        pt->edg[0] = pt1->edg[1] = R_EDGE;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);

        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        if ( pb->size < 0.0 ) {
          pt->ref  = R_PLUS;
          pt1->ref = R_MINUS;
        }
        else {
          pt->ref  = R_MINUS;
          pt1->ref = R_PLUS;
        }
      break;

      case 3:
        pt2 = &sm->tria[++sm->ne];
        pt2 = (pTriangle)memcpy(pt2,pt,sizeof(Triangle));
        pt->v[1]  = kk[0];
        pt->v[2]  = kk[1];
        pt1->v[2] = kk[0];
        pt2->v[0] = kk[1];
        pt2->v[1] = kk[0];
        pt->tag[0] = pt2->tag[2] = M_RIDGE_REF;
        pt->edg[0] = pt2->edg[2] = R_EDGE;
        pt->tag[2] = pt1->tag[1] = M_NOTAG;
        pt->edg[2] = pt1->edg[1] = 0;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);
        if ( pa->size < 0 ) {
          pt->ref  = pt1->ref = R_MINUS;
          pt2->ref = R_PLUS;
        }
        else {
          pt->ref  = pt1->ref = R_PLUS;
          pt2->ref = R_MINUS;
        }

        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        pa = &sm->point[pt2->v[0]];
        pb = &sm->point[pt2->v[1]];
        pc = &sm->point[pt2->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt2->qual,n);
      break;

      case 5:
        pt2 = &sm->tria[++sm->ne];
        pt2 = (pTriangle)memcpy(pt2,pt,sizeof(Triangle));
        pt->v[1]  = pt1->v[0] = kk[2];
        pt->v[2]  = pt1->v[2] = pt2->v[1] = kk[0];
        pt->tag[1] = pt2->tag[2] = M_NOTAG;
        pt->edg[1] = pt2->edg[2] = 0;
        pt->tag[0] = pt1->tag[1] = M_RIDGE_REF;
        pt->edg[0] = pt1->edg[1] = R_EDGE;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);
        if ( pa->size < 0.0 ) {
          pt->ref  = pt2->ref = R_MINUS;
          pt1->ref = R_PLUS;
        }
        else {
          pt->ref  = pt2->ref = R_PLUS;
          pt1->ref = R_MINUS;
        }

        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        pa = &sm->point[pt2->v[0]];
        pb = &sm->point[pt2->v[1]];
        pc = &sm->point[pt2->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt2->qual,n);
      break;

      case 6:
        pt2 = &sm->tria[++sm->ne];
        pt2 = (pTriangle)memcpy(pt2,pt,sizeof(Triangle));
        pt->v[1]  = kk[2];
        pt->v[2]  = kk[1];
        pt1->v[0] = kk[2];
        pt1->v[2] = kk[1];
        pt2->v[0] = kk[1];
        pt->tag[0]  = pt1->tag[1] = M_RIDGE_REF;
        pt->edg[0]  = pt1->edg[1] = R_EDGE;
        pt1->tag[0] = pt2->tag[2] = M_NOTAG; 
        pt1->edg[0] = pt2->edg[2] = 0;

        pa = &sm->point[pt->v[0]];
        pb = &sm->point[pt->v[1]];
        pc = &sm->point[pt->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt->qual,n);
        if ( pa->size < 0.0 ) {
          pt->ref  = R_MINUS;
          pt1->ref = pt2->ref = R_PLUS;
        }
        else {
          pt->ref  = R_PLUS;
          pt1->ref = pt2->ref = R_MINUS;
        }
 
        pa = &sm->point[pt1->v[0]];
        pb = &sm->point[pt1->v[1]];
        pc = &sm->point[pt1->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt1->qual,n);

        pa = &sm->point[pt2->v[0]];
        pb = &sm->point[pt2->v[1]];
        pc = &sm->point[pt2->v[2]];
        qualfa(pa->c,pb->c,pc->c,&pt2->qual,n);
      break;
    }
  }

  E_pop();
  return(nbe);
}


int updref(pSurfMesh sm) {
  pTriangle  pt,pta;
  pPoint     ppt;
  int        i,k,i1,i2,nbv,nv,ref;

  /* track isolated triangles */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    nbv = nv = 0;
    ref = pt->ref;
    for (i=0; i<3; i++) {
      if ( !pt->adj[i] )  continue;
      nv++;
      pta = &sm->tria[pt->adj[i]];
      if ( pta->ref != pt->ref ) {
        nbv++;
        ref = pta->ref;
      }
    }
    if ( nbv == nv ) {
      pt->ref = ref;
      for (i=0; i<3; i++) {
        if ( pt->adj[i] ) {
          pta = &sm->tria[pt->adj[i]];
          i1  = pt->voy[i];
          pt->tag[i]   = M_NOTAG;
          pt->edg[i]   = 0;
          pta->tag[i1] = M_NOTAG;
          pta->edg[i1] = 0;
        }
      }    
    }
  }

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
 
    for (i=0; i<3; i++) {
      if ( !pt->adj[i] )  continue;
      pta = &sm->tria[pt->adj[i]];
      if ( pta->ref != pt->ref ) {
        pt->tag[i] = M_RIDGE_REF;
        pt->edg[i] = R_EDGE;
        pta->tag[pt->voy[i]] = M_RIDGE_REF;
        pta->edg[pt->voy[i]] = R_EDGE;
        
        i1 = idir[i+1];
        i2 = idir[i+2];
        ppt = &sm->point[pt->v[i1]];
        if ( !ppt->ref ) //<= R_EDGE )
          ppt->ref  = pt->edg[i] ? pt->edg[i] : R_EDGE;
        ppt->tag  |= M_RIDGE_REF;
        ppt->color = sm->mark;

        ppt = &sm->point[pt->v[i2]];
        if ( !ppt->ref ) //<= R_EDGE )
          ppt->ref  = pt->edg[i] ? pt->edg[i] : R_EDGE;
        ppt->tag  |= M_RIDGE_REF;
        ppt->color = sm->mark;
      }
    }
  }

  return(1);
}


int chkRef(pSurfMesh sm) {
  pTriangle  pt,pta;
  pPoint     ppt;
  int        i,i1,i2,k,nb;

  /* check ref conformity */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( !pt->adj[i] ) {
        ppt = &sm->point[pt->v[i1]];
        //assert(ppt->ref);
        if ( !ppt->ref )  ppt->ref = R_EDGE;
        ppt = &sm->point[pt->v[i2]];
        //assert(ppt->ref);
        if ( !ppt->ref )  ppt->ref = R_EDGE;
      }
      else {
        pta = &sm->tria[pt->adj[i]];
        if ( pta->ref != pt->ref ) {
          ppt = &sm->point[pt->v[i1]];
          //assert(ppt->ref);
          if ( !ppt->ref )  ppt->ref = R_EDGE;
          ppt = &sm->point[pt->v[i2]];
          //assert(ppt->ref);
          if ( !ppt->ref )  ppt->ref = R_EDGE;
        }
      }
    }
  }

  nb = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->ref && ppt->tag == M_NOTAG ) {
      ppt->tag |= M_RIDGE_REF;
      nb++;
    }
    if ( !ppt->ref && ppt->tag > M_NOTAG ) {
      ppt->tag |= M_RIDGE_REF;
      nb++;
    }
  }

  if ( nb )
    fprintf(stdout,"  %% %d STRANGE POINTS....\n",nb);

  return(1);
}


int volTri(pSurfMesh sm) {
  pTriangle    pt;
	double       vol,ux,uy,uz,vx,vy,vz,nx,ny,nz;
	float       *a,*b,*c;
  int          k;

	vol = 0.0;
  for (k=1; k<=sm->ne; k++) {
		pt = &sm->tria[k];
		if ( !pt->v[0] || pt->ref != 3 )  continue;
		a = &sm->point[pt->v[0]].c[0];
		b = &sm->point[pt->v[1]].c[0];
		c = &sm->point[pt->v[2]].c[0];
		
		ux = b[0] - a[0];
		uy = b[1] - a[1];
		uz = b[2] - a[2];
    
		vx = c[0] - a[0];
		vy = c[1] - a[1];
		vz = c[2] - a[2];
    
		nx = uy*vz - uz*vy;
		ny = uz*vx - ux*vz;
		nz = ux*vy - uy*vx;
		vol += 0.5 * sqrt(nx*nx + ny*ny + nz*nz);
  }
  
	fprintf(stdout,"  %%%% Final Volume %E\n",vol);
  return(1);
}


int yams6(pSurfMesh sm) {
  int        cor,ret,npini,neini;

  /* default */
  E_put("yams6");
  npini = sm->np;
  neini = sm->ne;

  /* levelset subdivision */
  ret = levelset(sm);
  if ( ret < 0 )  return(0);
  else if ( !ret ) {
    E_pop();
    return(1);
  }

  if ( sm->np-sm->npfixe && imprim ) {
    yerr.inderr[0] = sm->np - npini;
    yerr.inderr[1] = sm->ne - neini;
    primsg(2008);
  }

  cor = sm->type & M_DETECT ? 1 : 0;
  if ( !updtop(sm) )  exit(1);
  if ( !setvoi(sm,cor) )  exit(1);
  if ( !updref(sm) )  exit(1);
  if ( !chkRef(sm) )  exit(1);
  if ( !volTri(sm) )  exit(1);

  E_pop();
  return(1);
}

