/*
 *  Uniform subdivision of triangles
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 2001.  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int yams4(pSurfMesh sm) {
  int     npini,neini;

  /* default */
  E_put("yams4");
  npini = sm->np;
  neini = sm->ne;

  /* uniform subdivision */
  if ( opts.iter > 1 ) {
    if ( !subdvd(sm,opts.iter) )  return(0);
    if ( !updtop(sm) )  exit(1);
  }

  if ( sm->np-sm->npfixe && imprim ) {
    yerr.inderr[0] = sm->np-npini;
    yerr.inderr[1] = sm->ne-neini;
    primsg(2008);
  }
  if ( imprim < -4 )  prigap(sm);

  E_pop();
  return(1);
}

