#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int yams3(pSurfMesh sm) {
  double     lbande,mbande,lgap,cgap,angdev,incdev;
  int        k,alert,maxtou,na,nad,nd,ndd,nde,ns,nsw,nptas;

  /* default */
  E_put("yams3");
  if ( abs(imprim) > 3 ) {
    yerr.cooerr[0] = 180.0*asin(opts.alpha)/M_PI;
    primsg(2006);
  }
  /*if ( !freelist(sm) )  return(0);*/

  /* build geometry */
  maxtou = max(1,min(10,opts.iter));
  lgap   = (opts.gap - ISQRT2) / maxtou;
  angdev = 1.0 - (1.0 - opts.geom) / maxtou;
  incdev = 1.0 - angdev;
  mbande = 0.5 * opts.bande / maxtou;
  lbande = mbande;
  nptas  = 0.2 * sm->npfixe;
  nad = nde = ndd = nsw = 0;

  for (k=1; k<=maxtou; k++) {
    cgap   = ISQRT2 + k*lgap;
    
    /* splitting */
    opts.degrad = 0.02*QUALCOE;
    na = analfa(sm,cgap,&alert);
    if ( na && !cassar(sm) ) {
      E_pop();
      return(0);
    }

    /* optimization */
    opts.degrad = QUALCOE;
    ns = optia3(sm,0,0.01);

    /* deletion */
    /*if ( !sm->nmfixe )
      nd = colar2(sm,lbande,angdev);
    else */
    nd = 0;

    if ( na+nd && abs(imprim) > 2 ) {
      yerr.inderr[0] = na;
      yerr.inderr[1] = nd;
      yerr.inderr[2] = ns;
      primsg(2011);
    }
    if ( alert )  break;
    nad += na;
    nde += nd;
    ndd += nd;
    nsw += ns;
    lbande += 2.0 * mbande;
    angdev -= incdev;
  
    if ( ndd > nptas ) {
      ndd = 0;
      taspoi(sm);
    }
  }

  if ( nad+nde > 5 && abs(imprim) < 3 ) {
    yerr.inderr[0] = nad;
    yerr.inderr[1] = nde;
    yerr.inderr[2] = nsw;
    primsg(2011);
  }
  if ( imprim < -4 )  prigap(sm);

  opts.degrad = QUALCOE;
  E_pop();
  return(1);
}
