/*
 *  Hausdorff decimation
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern mytime ctim[TIMEMAX];


int yams2(pSurfMesh sm) {
  double     lbande,mbande,incdev,angdev;
  float      declic;
  int        k,maxtou,ns,nsw,nd,ndd,nde,nm,nmv,nptas;

  /* default */
  E_put("yams2");
  if ( abs(imprim) > 3 )  primsg(2001);

  /* Hausdorff simplification */
  maxtou = 5;
  mbande = opts.bande / maxtou;
  lbande = mbande;
  angdev = 1.0 - (1.0-opts.geom) / maxtou;
  incdev = 1.0 - angdev;
  declic = 0.6 * ALPHAC;
  nptas  = 0.2 * sm->npfixe;
  nsw = nde = ndd = nmv = 0;

  ns = optia2(sm,lbande,angdev);
  if ( abs(imprim) > 2 && ns ) {
    yerr.inderr[0] = ns;
    primsg(2009);
  }

  for (k=1; k<=maxtou; k++) {
    if ( imprim < -4 ) {
      yerr.cooerr[0] = lbande;
      primsg(2003);
    }

    nd  = colar2(sm,lbande,angdev);
    if ( k == maxtou ) {
      lbande = opts.bande;
      declic = ALPHAC;
      nd    += colver(sm,0,lbande,angdev);
    }
    nm = ns = 0;
    if ( sm->type & M_SMOOTH && nd ) {
      chrono(ON,&ctim[9]);
      nm  = opticu(sm);
      nm += optpo2(sm,declic,opts.bande,angdev,&ns);
      chrono(OFF,&ctim[9]);
    }

    if ( abs(imprim) > 2 && nd+nm ) {
      yerr.inderr[0] = nd;
      yerr.inderr[1] = ns;
      yerr.inderr[2] = nm;
      yerr.cooerr[0] = acos(angdev)*180.0/M_PI;
      yerr.cooerr[1] = lbande;
      primsg(4005);
    }
    nsw += ns;
    nde += nd;
    ndd += nd;
    nmv += nm;
    lbande += mbande;
    angdev -= incdev;
    if ( ndd > nptas ) {
      ndd = 0;
      taspoi(sm);
    }
  }

  if ( abs(imprim) < 3 && nde ) {
    yerr.inderr[0] = nde;
    yerr.inderr[1] = nsw;
    yerr.inderr[2] = nmv;
    primsg(4001);
  }

  E_pop();
  return(!yerr.lerror);
}


/* clone of yams2 with npmax control */
int yams22(pSurfMesh sm) {
  double     lbande,mbande,incdev,angdev;
  float      declic;
  int        it,maxtou,ns,nsw,ndd,nd1,nd2,nde,nm,nmv,nptas;

  /* default */
  if ( opts.minnp > sm->np ) {
    E_pop();
    return(1);
  }
  E_put("yams22");
  if ( abs(imprim) > 3 )  primsg(2001);

  /* Hausdorff simplification */
  opts.bande = 0.01 * info.delta;
  opts.geom  = COS45DEG;
  maxtou = 20;
  mbande = opts.bande / maxtou;
  lbande = mbande;
  angdev = 1.0 - (1.0-opts.geom) / (maxtou/2);
  incdev = 1.0 - angdev;
  declic = 0.6 * ALPHAC;
  nptas  = 0.2 * sm->npfixe;
  nsw = nde = ndd = nmv = 0;
  sm->np -= info.nulp;

  ns = optia2(sm,lbande,angdev);
  if ( abs(imprim) > 2 && ns ) {
    yerr.inderr[0] = ns;
    primsg(2009);
  }

  it = 0;
  while ( sm->np > opts.minnp && ++it <= maxtou ) {
    if ( !hipini(sm,1) )  return(0);

    nd1  = colar22(sm,opts.minnp,lbande,angdev);
    sm->np -= nd1;
    nd2  = colver(sm,opts.minnp,lbande,angdev);
    sm->np -= nd2;
    nm  = 0;
    if ( sm->type & M_SMOOTH && nd1+nd2 ) {
      chrono(ON,&ctim[9]);
      nm  = opticu(sm);
      nm += optpo2(sm,declic,lbande,angdev,&ns);
      chrono(OFF,&ctim[9]);
    }

    if ( abs(imprim) > 2 && nd1+nd2+nm ) {
      yerr.inderr[0] = nd1+nd2;
      yerr.inderr[1] = ns;
      yerr.inderr[2] = nm;
      yerr.cooerr[0] = acos(angdev)*180/M_PI;
      yerr.cooerr[1] = lbande;
      primsg(4005);
    }
    nsw += ns;
    nde += nd1+nd2;
    ndd += nd1+nd2;
    nmv += nm;
    lbande += mbande;
    angdev -= incdev;
    /*
    if ( ndd > nptas ) {
      ndd = 0;
      taspoi(sm);
    }
    */
  }
  opts.bande = lbande;

  if ( abs(imprim) < 3 && nde ) {
    yerr.inderr[0] = nde;
    yerr.inderr[1] = nsw;
    yerr.inderr[2] = nmv;
    primsg(4001);
  }

  hipfree();

  E_pop();
  return(1);
}


