#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern mytime ctim[TIMEMAX];
extern Options     opts;


/* compute metric */
int calmet(pSurfMesh sm) {

  chrono(ON,&ctim[8]);
  if ( opts.ctrl & ISO ) {
    if ( !radpoi(sm) )   return(0);
    if ( !radedg_a(sm) ) return(0);
    if ( !cutmet(sm) )   return(0);
    if ( !sizcor(sm) )   return(0);
  }
  else {
    if ( !radpoi_a(sm) ) return(0);
    if ( !radedg_a(sm) ) return(0);
    if ( !sizcor_a(sm) ) return(0);
    if ( !updqua_a(sm) ) return(0);
  }
  chrono(OFF,&ctim[8]);
  if ( imprim < -4 )  prilen(sm);
  return(1);
}


int yams1(pSurfMesh sm) {
  double   cgap,lgap;
  float    declic;
  int      it,maxtou,nde,ndd,nd,nmv,nm,ns,nsw,npdep;
  int      alert,savdep,nad,na,dd,nptas;

  /* default */
  E_put("yams1");
  if ( abs(imprim) > 3 )  primsg(4010);

  /* compute metric */
  if ( !calmet(sm) )  return(0);

  nde = ndd = nad = nmv = nsw = 0;
  if ( imprim < -4 )  primsg(4011);
  maxtou = 15;
  it     = 1;
  npdep  = 1;
  alert  = sm->np > sm->npmax-4;
  nptas  = 0.2 * sm->npfixe;
  declic = 0.12;
  lgap   = (opts.gap - ISQRT2) / maxtou;
  na = nd = 0;

  do {
    cgap = ISQRT2 + it*lgap;

    /* splitting */
    savdep = sm->np;
    if ( !alert && sm->type & M_ENRICH ) {
      opts.degrad = 0.01*QUALCOE;
      if ( opts.ctrl & ISO ) {
        na = analar(sm,cgap,&alert);
        if ( na && !cassar(sm) ) {
          E_pop();
          return(0);
        }
      }
      else {
        na = analar_a(sm,cgap,&alert);
        if ( na && !cassar_a(sm) ) {
          E_pop();
          return(0);
        }
      }
      nad += na;
    }
    else if ( alert )  na = 0;

    /* deletion */
    opts.degrad = QUALCOE;
    ns   = optia1(sm,declic);
    nd   = colar1(sm,sm->np);
    nde += nd;
    ndd += nd;

    /* optimization */
    nm  = 0;
    if ( it > 3 && sm->type & M_SMOOTH ) {
      chrono(ON,&ctim[3]);
      nm  = opticu(sm);
      if ( opts.ctrl & ISO )
        nm += optpo1(sm,npdep,declic,cgap,&ns);
      else
        nm += optlen_a(sm,npdep,declic,cgap,&ns);
      chrono(OFF,&ctim[3]);
      nmv += nm;
    }
    nsw  += ns;
    npdep = savdep+1;

    if ( na+nd && abs(imprim) > 2 ) {
      yerr.inderr[0] = na;
      yerr.inderr[1] = nd;
      yerr.inderr[2] = ns;
      yerr.inderr[3] = nm;
      primsg(2013);
    }
    if ( na+nd == 0 )  break;
    else if ( it > 5 ) {
      dd = abs(nd-na);
      if ( dd < 5 || dd < 0.05*nd )  break;
      else if ( it > 6 && nd > na )  break;
    }
    if ( ndd > nptas ) {
      ndd = 0;
      taspoi(sm);
    }
    declic *= 1.02;
    declic = min(declic,0.5);
  }
  while ( na+nd > 2 && ++it <= maxtou );

  if ( nad+nde && abs(imprim) < 3 ) {
    yerr.inderr[0] = nad;
    yerr.inderr[1] = nde;
    yerr.inderr[2] = nsw;
    yerr.inderr[3] = nmv;
    primsg(2013);
  }

  opts.degrad = QUALCOE;
  E_pop();
  return(1);
}
