#include "compil.date"

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern mytime  ctim[TIMEMAX];
extern ubyte   ecp;


int yams0(pSurfMesh sm,int mem,int *choix) {
  int    bb,imp,absopt;

  /* print header */
  E_put("yams0");
  if ( imprim == -99 ) {
    fprintf(stdout,"  -- PRINT (0 10(advised) -10) ?\n");
    fflush(stdin);
    fscanf(stdin,"%d",&imp);
    imprim = imp;
  }

  if ( imprim ) {
    if ( ecp )
      fprintf(stdout,"  ## Version:  Ecole Centrale de Paris ##\n\n");
    fprintf(stdout,"  -- YAMS (LJLL) Version %s (%s)\n",VERSION,RELEASE);
    fprintf(stdout,"     %s.\n",COPYRIGHT);
    fprintf(stdout,"     compiled: %s.\n\n",COMPIL);
  }

  /* parse arguments and options */
  if ( sm->infile == NULL ) {
    sm->infile = (char *)calloc(128,sizeof(char));
    if ( !sm->infile ) {
      yerr.lerror = TRUE;
      yerr.coderr = 0002;
      return(0);
    }
    fprintf(stdout,"  -- FILE BASENAME ?\n");
    fflush(stdin); 
    fscanf(stdin,"%s",sm->infile);
  }

  /* get options */
  fprintf(stdout,"   OPTION ? : (<0:decim, >0:enrich)\n");
  fprintf(stdout,"     0,   -1, 1,   -2, 2,     3,    9 \n");
  fprintf(stdout,"   optim,  F.E., Hausdorff, geom, smooth\n");
  fflush(stdin);
  if ( *choix == -99 )
    fscanf(stdin,"%d",choix);
  else
    fprintf(stdout,"%d\n",*choix);

  /* check option */
  if ( (*choix) > 0 )
    sm->type |= M_ENRICH;
  else
    mem = -1;

  /*
  if ( abs(*choix) > 4 && !(sm->type & M_QUADS) )
    sm->type &= ~M_SMOOTH;
  */
  if ( !(opts.ctrl & ISO) && abs(*choix) != 1 && abs(*choix) != 6 )
    opts.ctrl ^= ISO;

  /* input data */
  if ( imprim )   fprintf(stdout,"  -- INPUT DATA\n");
  chrono(ON,&ctim[5]);

  /* parsing program options */
  if ( imprim < 0 )
    fprintf(stdout,"  -- PARSING PROGRAM OPTIONS\n");
  parsop(sm,sm->infile);

  if ( imprim < 0 ) {
    fprintf(stdout,"     OPERATION COMPLETED\n");
    fprintf(stdout,"\n  -- READING DATA FILE %s\n",sm->infile);
  }

  /* read input files */
  if ( !loadMesh(sm,sm->infile,mem,*choix) ) {
      fprintf(stderr,"  ** %s  NOT FOUND.\n",sm->infile);
      yerr.coderr = 0003;
      return(0);
  }
  sm->ne = sm->nefixe;
  sm->np = sm->npfixe;
  bb = loadSol(sm,sm->infile);
  sm->nmfixe = bb ? sm->npfixe : 0;

  /* read metric info  */
  absopt = abs(*choix);

  chrono(OFF,&ctim[5]);
  if ( imprim ) {
    fprintf(stdout,"     NUMBER OF GIVEN VERTICES    %8d\n",sm->npfixe);
    fprintf(stdout,"     NUMBER OF GIVEN TRIANGLES   %8d\n",sm->nefixe);
    fprintf(stdout,"  -- DATA READING COMPLETED.     %.2f sec.\n",
            gttime(ctim[5]));
    if ( imprim < -4 )  priopt(*choix);
  }

  E_pop();
  return(1);
}
