#define  __YAMS

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

#include "yams.h"
#include "defines.h"
#include "sproto.h"


/* globals (see globals.h) */
Error       yerr;
Info        info;
Options     opts;
pHashtable  hash;
mytime      ctim[TIMEMAX];

long      nhmax,hnext,hsize;
int       out,idir[5] = {0,1,2,0,1},idirq[7] = {0,1,2,3,0,1,2};
short     imprim;
ubyte     ddebug;
ubyte     ecp;


static void excfun(int sigid) {
  switch(sigid){
  case SIGFPE:
    fprintf(stderr,"  ## FP EXCEPTION. STOP\n");
    break;
  case SIGILL:
    fprintf(stderr,"  ## ILLEGAL INSTRUCTION. STOP\n");
    break;
  case SIGSEGV:
    fprintf(stderr,"  ## SEGMENTATION FAULT. STOP\n");
    break;
  case SIGABRT:
  case SIGTERM:
  case SIGINT:
    fprintf(stderr,"  ## ABNORMAL END. STOP\n");
    break;
  }
  out = 0;
  exit(1);
}


static void endcod() {
  chrono(OFF,&ctim[0]);
  chrono(OFF,&ctim[1]);
  E_dump();
  if ( out <= 0 ) {
    prierr(WAR,8002);
    fprintf(stdout,"\n   ELAPSED TIME  %.2f SEC.\n",gttime(ctim[0]));
  }
}


int main(int argc,char *argv[]) {
  pSurfMesh   sm;
  float       declic;
  int         option,absopt,ret,memory,corr;
  short       phase;

  /* trap exceptions */
  signal(SIGABRT,excfun);
  signal(SIGFPE,excfun);
  signal(SIGILL,excfun);
  signal(SIGSEGV,excfun);
  signal(SIGTERM,excfun);
  signal(SIGINT,excfun);
  atexit(endcod);

  /* init time and calls */
  tminit(ctim,TIMEMAX);
  chrono(ON,&ctim[0]);

  /* assign default values */
  yerr.lerror = FALSE;
  yerr.coderr = 0;
  phase  = 0;
  ret    = TRUE;
  out    = -1;
  memory = -1;
  imprim = -99;
  option = -99;
  ddebug = FALSE;
  declic = 0.009;
  ecp    = 0;

  /* allocate memory for mesh structure */
  E_put("yams");
  sm = (pSurfMesh)M_calloc(1,sizeof(SurfMesh),"yams");
  if ( !sm ) {
    prierr(ERR,0002);
    exit(1);
  }

  /* setting defaults */
  sm->infile  = NULL;
  sm->outfile = NULL;
  sm->type    = M_SMOOTH | M_QUERY | M_DETECT | M_BINARY | M_OUTPUT;
  inival();

  /* get decimation parameters */
  parsar(sm,argc,argv,&memory,&option);
  opts.choix = option;

  /* read input data */
  if ( !yams0(sm,memory,&option) ) {
    prierr(ERR,yerr.coderr);
    return(1);
  }
  absopt = abs(option);

  /* set adjacencies  */
  chrono(ON,&ctim[1]);
  chrono(ON,&ctim[2]);
  ret = tabvo2(sm,declic);
  chrono(OFF,&ctim[2]);
  if ( !ret ) {
    prierr(ERR,yerr.coderr);
    exit(1);
  }

  /* print surface quality */
  if ( imprim ) {
    if ( opts.ctrl & ISO ) 
      priqua(sm);
    else if ( sm->metric )
      priqua_a(sm);
    primsg(0000);
    if ( abs(imprim) > 1 ) {
      yerr.inderr[0] = sm->npmax;
      yerr.inderr[1] = sm->nemax;
      primsg(0002);
    }
  }

  /* pre-processing stage */
  yerr.inderr[0] = ++phase;
  out = 0;
  if ( abs(imprim) > 1 )  primsg(1000);
  chrono(ON,&ctim[2]);
  corr = sm->type & M_DETECT ? 1 : 0;
  if ( !setvoi(sm,corr) )   exit(1);
  if ( !ptmult(sm) )   exit(1);
  if ( absopt < 6 ) { 
    declic = 0.038;
		declic = opts.ctrl & ISO ? 1e-6 : 1.e-8;
    if ( !sident(sm,corr) )    exit(1);
    //if ( !delnul(sm,declic) )  exit(1);
    if ( !optedg(sm) )         exit(1);
  }
  if ( sm->type & M_DETECT && !sident(sm,1) )  exit(1);

  /* smoothing */
  if ( absopt == 9 ) {
    if ( !noshrk(sm,opts.check) )  exit(1);
	  //if ( !hilbert(sm) )  exit(1);
    //if ( !denois(sm) )  exit(1);
  }
  else {
    if ( opts.iter < 0 )  opts.iter = 5;
    if ( absopt < 5 ) {
      if ( !norpoi(sm,0,corr) )  exit(1);
      if ( !tgepoi(sm,0,corr) )  exit(1);
    }
  }
  chrono(OFF,&ctim[2]);

  yerr.inderr[0] = phase;
  yerr.cooerr[0] = gttime(ctim[2]);
  if ( abs(imprim) > 1 ) {
    primsg(1001);
    if ( imprim < -4 ) {
      bilan(sm);
      prigap(sm);
    }
  }

  /* surface remeshing */
  yerr.inderr[0] = ++phase;
  if ( absopt && absopt <= 6 ) {
    if ( abs(imprim) > 1 )  primsg(1000);
    chrono(ON,&ctim[4]);

    /* geometry enrichment */
    if ( option > 0 ) {
      chrono(ON,&ctim[6]);
      if ( option == 4 )
        ret = yams4(sm);
      else if ( option == 6 )
        ret = yams6(sm);
       else
        ret = yams3(sm);
      chrono(OFF,&ctim[6]);
      if ( !ret )  exit(1);
    }

    /* surface simplification */
    if ( absopt == 1 )
      ret = yams1(sm);
    else if ( absopt == 2 ) {
      if ( opts.minnp < 0 )
        ret = yams2(sm);
      else
        ret = yams22(sm);
    }
    else if ( absopt == 5 && sm->type & M_METRIC ) 
      ret = calmet(sm);
    chrono(OFF,&ctim[4]);
    if ( !ret )  exit(1);

    yerr.inderr[0] = phase;
    yerr.cooerr[0] = gttime(ctim[4]);
    if ( abs(imprim) > 1 ) {
      primsg(1001);
      if ( imprim < -4 ) {
        if ( opts.ctrl & ISO )
          priqua(sm);
        else
          priqua_a(sm);
        prilen(sm);
      }
    }
  }

  /* mesh optimization */
  yerr.inderr[0] = ++phase;
  if ( absopt < 4 && absopt != 2 && yerr.coderr != 4000 ) {
    if ( abs(imprim) > 1 )  primsg(1000);

    if ( sm->type & M_SMOOTH && yerr.coderr != 4000 ) {
      chrono(ON,&ctim[3]);
      ret = optra4(sm,option);
      chrono(OFF,&ctim[3]);
      if ( !ret )  exit(1);
    }
    if ( absopt < 2 && opts.ffem && !optfem(sm) )  exit(1);

    yerr.inderr[0] = phase;
    yerr.cooerr[0] = gttime(ctim[3]);
    if ( abs(imprim) > 1 ) primsg(1001);
  }

  /* convert to quads (09-2003) */
  if ( sm->type & M_QUADS ) {
    yerr.inderr[0] = ++phase;
    if ( abs(imprim) > 1 )  primsg(1000);
    chrono(ON,&ctim[4]);

    if ( !yamsq(sm) )  exit(1);
 
    yerr.inderr[0] = phase;
    yerr.cooerr[0] = gttime(ctim[4]);    
    if ( abs(imprim) > 1 )  primsg(1001);
  }
  chrono(OFF,&ctim[1]);

  /* evaluation histograms */
  if ( abs(imprim) > 1 && absopt < 10 ) {
    if ( sm->type & M_QUADS )
      outqua_q(sm);
    else {
      if ( absopt == 1 )  prilen(sm);
      if ( opts.ctrl & ISO )
        outqua(sm);
      else {
	      outqua_a(sm);
        outqua1_a(sm);
      }
      if ( sm->connex && info.cc > 1 )  rchsub(sm);
    }
  }
  if ( abs(imprim) > 1 )  primsg(0001);

  /* write resulting mesh */
  if ( sm->type & M_OUTPUT ) {
    chrono(ON,&ctim[5]);
    out = yams8(sm,sm->outfile,absopt);
    chrono(OFF,&ctim[5]);
  }
  else if ( imprim )  priout(sm);

  /* print CPU requirements */
  chrono(OFF,&ctim[0]);
  if ( imprim ) {
    if ( imprim < 0 ) primem(sm->npmax);
    pritim(sm,option);
  }

  /* release allocated memory */
  M_free(sm->point);
  M_free(sm->tria);
  M_free(sm->geom);
  M_free(sm->tgte);
  if ( sm->metric ) M_free(sm->metric);
  if ( sm->edge )   M_free(sm->edge);
  M_free(hash);
  M_free(sm);

  /* check for mem leaks */
  if ( imprim < 0 && M_memLeak() )  M_memDump();

#ifdef DISTRIB
  /* free token */
  if ( !IsKeyCodeProtected(keycode) )
    free_token(&token);
#endif

  return(0);
}

