#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int updtop(pSurfMesh sm) {
  pTriangle    pt;
  int          i,i1,i2,k;

  /* realloc hash table */
  E_put("updtop");
  M_free(hash);
  hash = 0;
  if ( !zaldy2(sm->npmax) )  return(0);

  /* hash edges */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->adj[0] = pt->adj[1] = pt->adj[2] = 0;
    pt->voy[0] = pt->voy[1] = pt->voy[2] = 0;
  }

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( !hcode(sm,pt->v[i1],pt->v[i2],k,i) ) {
	      yerr.inderr[0] = pt->v[i1];
	      yerr.inderr[1] = pt->v[i2];
        yerr.inderr[2] = k;
	      prierr(WAR,1001);
	      return(0);
      }
    }
  }

  E_pop();
  return(1);
}


int updtop_q(pSurfMesh sm) {
  pQuad     pq;
  int       k;
  ubyte     i,i1;

  /* realloc hash */
  E_put("updtop_q");
  M_free(hash);
  nhmax = max(3.71 * sm->np,NHMAX);
  hash  = (pHashtable)M_calloc(nhmax+2,sizeof(Hashtable),"zaldy2");
  assert(hash);

  hsize = 2 * sm->np;
  hnext = hsize;
  for (k=hsize; k<nhmax; k++)
    hash[k].nxt = k+1;

  /* update */
  for (k=1; k<=sm->nq; k++) {
    pq = &sm->quad[k];
    if ( !pq->v[0] )  continue;

    for (i=0; i<4; i++) {
      i1 = idirq[i+1];
      if ( !hcode_q(sm,pq->v[i],pq->v[i1],k,i) ) {
	      yerr.inderr[0] = pq->v[i];
	      yerr.inderr[1] = pq->v[i1];
        yerr.inderr[2] = k;
	      prierr(WAR,1001);
	      return(0);
      }
    }
  }

  E_pop();
  return(1);
}
