#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int tgepoi(pSurfMesh sm,int npdep,int corr) {
  pTriangle  pt,pt1;
  pPoint     p1,p2,p3,p11,p22;
  double     ax,ay,az,bx,by,bz,dd,d1,d2;
  float     *tg;
  int        i,k,i1,i2,adj,ncor;

  /* default */
  E_put("tgepoi");
  ncor = 0;
  for (k=1; k<=sm->np; k++) {
    p1 = &sm->point[k];
    if ( k > npdep )  p1->tge = 0;
  }

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    /* analyze edges */
    for (i=0; i<3; i++) {
      if ( pt->tag[i] == M_NOTAG )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      p1 = &sm->point[pt->v[i1]];
      p2 = &sm->point[pt->v[i2]];
      p3 = &sm->point[pt->v[i]];
      if ( (p1->tag & M_CORNER) && (p2->tag & M_CORNER) )  continue;

      ax = p2->c[0] - p1->c[0];
      ay = p2->c[1] - p1->c[1];
      az = p2->c[2] - p1->c[2];
      d1 = sqrt(ax*ax + ay*ay + az*az);
      if ( d1 < EPSD )  continue;
      d1 = 1.0f / d1;
      ax *= d1;
      ay *= d1;
      az *= d1;

      /* check memory */
      if ( sm->nt > sm->ntmax-3 && !zaldy3(sm,2) )  return(0);

      if ( !p1->tge ) {
        pt1 = pt;
        adj = pt->adj[i2];
        /* find opposite endpoint */
        while ( pt1->tag[i2] == M_NOTAG && adj != k ) {
          adj = pt1->adj[i2];
          i2  = idir[pt1->voy[i2]+2];
          pt1 = &sm->tria[adj];
        }
        i1  = idir[i2+1];
        p11 = &sm->point[pt1->v[i1]];

        /* compute discrete tangent */
        bx = p11->c[0] - p1->c[0];
        by = p11->c[1] - p1->c[1];
        bz = p11->c[2] - p1->c[2];
        d2 = sqrt(bx*bx + by*by + bz*bz);
        if ( d2 < EPSD )  continue;
        d2 = 1.0f / d2;
        bx *= d2;
        by *= d2;
        bz *= d2;

        /* tangent = bissectrice */
        tg = sm->tgte[++sm->nt].t;
        p1->tge = sm->nt;
        tg[0] = ax - bx;
        tg[1] = ay - by;
        tg[2] = az - bz;
        dd = sqrt(tg[0]*tg[0] + tg[1]*tg[1] + tg[2]*tg[2]);
        
        /* normalize */
        if ( dd < EPSD )  continue;
        dd = 1.0f / dd;
        tg[0] *= dd;
        tg[1] *= dd;
        tg[2] *= dd;

        /* check tangent */
        if ( corr ) {
          dd  = (ay*tg[2] - az*tg[1]) * pt->n[0];
          dd += (az*tg[0] - ax*tg[2]) * pt->n[1];
          dd += (ax*tg[1] - ay*tg[0]) * pt->n[2];
          if ( dd > 0.0 ) {
            bx = p3->c[0] - p1->c[0];
            by = p3->c[1] - p1->c[1];
            bz = p3->c[2] - p1->c[2];
            dd = sqrt(bx*bx + by*by + bz*bz);
            if ( dd < EPSD )  continue;
            dd = 1.0 / dd;
            bx *= dd;
            by *= dd;
            bz *= dd;
            d1 = tg[0]*ax + tg[1]*ay + tg[2]*az;
            d2 = bx*ax + by*ay + bz*az;
            if ( d1 < d2 ) {
              tg[0] = bx;
              tg[1] = by;
              tg[2] = bz;
              ncor++;
            }
          }
        }
      }

      if ( !p2->tge ) {
        i1  = idir[i+1];
        i2  = idir[i+2];
	    pt1 = pt;
        adj = pt->adj[i1];
	    /* find opposite endpoint */
	    while ( pt1->tag[i1] == M_NOTAG && adj != k ) {
	      adj = pt1->adj[i1];
	      i1  = idir[pt1->voy[i1]+1];
	      pt1 = &sm->tria[adj];
	    }
	    i2  = idir[i1+2];
	    p22 = &sm->point[pt1->v[i2]];

	    /* compute discrete tangent */
	    bx = p22->c[0] - p2->c[0];
	    by = p22->c[1] - p2->c[1];
	    bz = p22->c[2] - p2->c[2];
	    d2 = sqrt(bx*bx + by*by + bz*bz);

        if ( d2 < EPSD )  continue;
        d2 = 1.0f / d2;
        bx *= d2;
        by *= d2;
        bz *= d2;

	    /* tangent = bissectrice */
        tg = sm->tgte[++sm->nt].t;
        p2->tge = sm->nt;
	    tg[0] = -ax - bx;
	    tg[1] = -ay - by;
	    tg[2] = -az - bz;
        dd    = sqrt(tg[0]*tg[0] + tg[1]*tg[1] + tg[2]*tg[2]);

        /* normalize */
        if ( dd < EPSD )  continue;
        dd = 1.0f / dd;
        tg[0] *= dd;
        tg[1] *= dd;
        tg[2] *= dd;
       
        /* check tangent */
        if ( corr ) {
          dd  = (ay*tg[2] - az*tg[1]) * pt->n[0];
          dd += (az*tg[0] - ax*tg[2]) * pt->n[1];
          dd += (ax*tg[1] - ay*tg[0]) * pt->n[2];
          if ( dd > 0.0 ) {
            bx = p3->c[0] - p2->c[0];
            by = p3->c[1] - p2->c[1];
            bz = p3->c[2] - p2->c[2];
            dd = sqrt(bx*bx + by*by + bz*bz);
            if ( dd < EPSD )  continue;
            dd = 1.0 / dd;
            bx *= dd;
            by *= dd;
            bz *= dd;
            d1 = tg[0]*ax + tg[1]*ay + tg[2]*az;
            d2 = bx*ax + by*ay + bz*az;
            if ( d1 > d2 ) {
              tg[0] = bx;
              tg[1] = by;
              tg[2] = bz;
              ncor++;
            }
          }
        }
      }
    }
  }
  if ( imprim < 0 && ncor > 0 ) {
    yerr.inderr[0] = ncor;
    prierr(WAR,4016);
  } 
  E_pop();
  return(1);
}
