#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int taspoi(pSurfMesh sm) {
  pPoint     pdeb,pfin;
  pEdge      adeb,afin;
  pTriangle  tdeb,tfin;
  int        k,nadeb,nafin,npdeb,npfin,nedeb,nefin,nswap;
  ubyte      i,i1,i2;

  E_put("taspoi");
  if ( imprim < 0 )  primsg(1030);

  /* vertices */
  nswap = 0;
  npdeb = 0;
  npfin = sm->np;
  while ( ++npdeb < npfin ) {
    pdeb = &sm->point[npdeb];
    if ( pdeb->tag & M_UNUSED ) {
      while ( sm->point[npfin].tag & M_UNUSED && npfin > npdeb )  npfin--;
      pfin = &sm->point[npfin];
      memcpy(pdeb,pfin,sizeof(Point));
      if ( sm->metric )
        memcpy(&sm->metric[npdeb],&sm->metric[npfin],sizeof(Metric));
      pfin->tmp = npdeb;
      pfin->tag = M_UNUSED;
      nswap++;
    }
    pdeb->tmp = npdeb;
  }
  if ( !nswap ) {
    E_pop();
    return(1);
  }
  sm->np = npdeb - 1;

  /* elements */
  nswap = 0;
  nedeb = 0;
  nefin = sm->ne;
  while ( ++nedeb < nefin ) {
    tdeb = &sm->tria[nedeb];
    if ( !tdeb->v[0] ) {
      while ( !sm->tria[nefin].v[0] && nefin > nedeb )  nefin--;
      if ( nefin <= nedeb )  break;
      tfin = &sm->tria[nefin];
      memcpy(tdeb,tfin,sizeof(Triangle));
      tfin->v[0] = 0;
      nswap++;
    }
    for (i=0; i<3; i++) {
      tdeb->v[i]   = sm->point[tdeb->v[i]].tmp;
      tdeb->adj[i] = 0;
      tdeb->voy[i] = 0;
    }
  }
  sm->ne = nedeb - 1;

  /* update topo */
  hinit(sm->npmax);
  for (k=1; k<=sm->ne; k++) {
    tdeb = &sm->tria[k];
    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( !hcode(sm,tdeb->v[i1],tdeb->v[i2],k,i) ) {
	yerr.inderr[0] = tdeb->v[i1];
	yerr.inderr[1] = tdeb->v[i2];
        yerr.inderr[2] = k;
	prierr(ERR,1001);
        exit(1);
      }
    }
  }

  if ( sm->edge ) {
    nadeb = 0;
    nafin = sm->nafixe;
    while (++nadeb < nafin ) {
      adeb = &sm->edge[nadeb];
      if ( !adeb->p1 || !adeb->p2 ) {
        while ( !sm->edge[nafin].p1 && nafin > nadeb )  nafin--;
        afin = &sm->edge[nafin];
        memcpy(adeb,afin,sizeof(Edge));
        afin->p1 = afin->p2 = 0;
        nswap++;
      }
      adeb->p1 = sm->point[adeb->p1].tmp;
      adeb->p2 = sm->point[adeb->p2].tmp;
    }
  }

  if ( ddebug )  debug(sm,0);
  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
