#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* merge two mesh vertices */
int mergePoint(pSurfMesh sm,int ia,int ib) {	
  pTriangle  pt;  
  pPoint     pa,pb;
  int        i,i1,i2,k,ip;
//return(1);
  pa = &sm->point[ia];
  pb = &sm->point[ib];

  if ( pa->tag > pb->tag ) {
	ip = ia;
	ia = ib;
	ib = ip;
    pa = &sm->point[ia];
    pb = &sm->point[ib];
  }

  for (k=1; k<=sm->ne; k++) {
	pt = &sm->tria[k];
	if ( !pt->v[0] )  continue;
	for (i=0; i<3; i++) {
	  if ( pt->v[i] == ia ) {
		pt->v[i] = ib;
		i1 = idir[i+1];
		i2 = idir[i+2];
	    if ( pt->v[i1] == ib || pt->v[i2] == ib )
		  pt->v[0] = 0;
		break;
	  }
    }
  }

  pb->tag = M_UNUSED;
  return(1);
}


int tabvo2(pSurfMesh sm,float declic) {
  pTriangle  pt,pta;
  pPoint     ppt,p0,p1,p2;
  pEdge      pte;
  double     ax,ay,az,bx,by,bz,d,d1,d2,d3;
  int        i,i1,i2,j,k,adj,voy,disc;

  /* default */
  E_put("tabvo2");
  if ( !zaldy2(sm->npmax) )  return(0);

  /* set adjacency */
  info.qworst = 2.0;
  disc = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    /* retrieve vertices */
    p0 = &sm->point[pt->v[0]];
    p1 = &sm->point[pt->v[1]];
    p2 = &sm->point[pt->v[2]];

    /* find min and max edge length */
    ax = p1->c[0] - p0->c[0];
    ay = p1->c[1] - p0->c[1];
    az = p1->c[2] - p0->c[2];
    d1 = ax*ax + ay*ay + az*az;

    if ( d1 < info.dmin )  info.dmin = d1;
    if ( d1 > info.dmax )  info.dmax = d1;

    bx = p2->c[0] - p0->c[0];
    by = p2->c[1] - p0->c[1];
    bz = p2->c[2] - p0->c[2];
    d2 = bx*bx + by*by + bz*bz;

    if ( d2 < info.dmin )  info.dmin = d2;
    if ( d2 > info.dmax )  info.dmax = d2;

    /* compute face normal */
    pt->n[0] = ay*bz - az*by;
    pt->n[1] = az*bx - ax*bz;
    pt->n[2] = ax*by - ay*bx;
    d = pt->n[0]*pt->n[0] + pt->n[1]*pt->n[1] + pt->n[2]*pt->n[2];
    if ( d > EPS2 ) {
      d = sqrt(d);
      pt->qual  = d;
      d = 1.0 / d;
      pt->n[0] *= d;
      pt->n[1] *= d;
      pt->n[2] *= d;
    }
    else {
      pt->qual = 0.0;
      info.nulf++;
      info.qpire++;
      if ( typelt(sm,k) == 4 ) {
	    ax = p2->c[0] - p1->c[0];
	    ay = p2->c[1] - p1->c[1];
	    az = p2->c[2] - p1->c[2];
	    d3 = ax*ax + ay*ay + az*az;
/*
		if ( d1 < EPSD ) {
		  mergePoint(sm,pt->v[0],pt->v[1]);
	      continue;
		}
		else if ( d2 < EPSD ) {
		  mergePoint(sm,pt->v[0],pt->v[2]);
	      continue;
		}
		else if ( d3 < EPSD ) {
		  mergePoint(sm,pt->v[1],pt->v[2]);
	      continue;
	    }
*/
	  }
    }
    ax = p2->c[0] - p1->c[0];
    ay = p2->c[1] - p1->c[1];
    az = p2->c[2] - p1->c[2];
    d3 = ax*ax + ay*ay + az*az;

    if ( d3 < info.dmin )  info.dmin = d3;
    if ( d3 > info.dmax )  info.dmax = d3;

    /* update face quality (iso!) */
    d = d1+d2+d3;
    if ( d > 0.0 )  pt->qual /= d;
    if ( pt->qual < declic )  info.qpire++;

    /* keep worst face */
    if ( pt->qual < info.qworst )
      info.qworst = pt->qual;
  }

  /* update hash */
  for (k=1; k<=sm->ne; k++) {
	  pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( !hcode(sm,pt->v[i1],pt->v[i2],k,i) ) {
	    yerr.inderr[0] = pt->v[i1];
	    yerr.inderr[1] = pt->v[i2];
      yerr.inderr[2] = k;
			prierr(WAR,1001);
	    pt->v[0] = 0;
	    disc++;
      }
    }
  }

  if ( info.dmin > 0.0 )
    info.dmin = sqrt(info.dmin);
  if ( info.dmax > 0.0 )  
    info.dmax = sqrt(info.dmax);

  if ( disc > 0 ) {
    yerr.inderr[0] = disc;
    prierr(WAR,0022);
  }

  /* hash specified edges */
  info.ndang = 0;
  if ( sm->edge != NULL ) {
    for (k=1; k<=sm->nafixe; k++) {
      pte = &sm->edge[k];
	    p0  = &sm->point[pte->p1];
	    p1  = &sm->point[pte->p2];
	    if ( p0->tag == M_UNUSED || p1->tag == M_UNUSED )  continue;

      /* check dangling edge */
      if ( hedge(pte->p1,pte->p2,&j,&i) ) {
	    pt = &sm->tria[j];
	    pt->edg[i]  = pte->ref;
	    pt->tag[i] |= pte->tag;
				
        adj = pt->adj[i];
	    voy = pt->voy[i];
	    while ( adj && adj != j ) {
	      pta = &sm->tria[adj];
	      pta->edg[voy] = pte->ref;
	      pta->tag[voy] = pt->tag[i];
	  
	      adj = pta->adj[voy];
	      voy = pta->voy[voy];
	    }
	    /* de-activate edge */
	    pte->p1 = pte->p2 = 0;
      }
      else {
        fprintf(stdout,"  Dangling edge: %d %d\n",pte->p1,pte->p2);
	    info.ndang++;
      }
    }
    if ( info.ndang == 0 ) {
      M_free(sm->edge);
      sm->edge = 0;
    }
  }

  /* bounding box size */
  info.delta  = (info.xmax-info.xmin) * (info.xmax-info.xmin);
  info.delta += (info.ymax-info.ymin) * (info.ymax-info.ymin);
  info.delta += (info.zmax-info.zmin) * (info.zmax-info.zmin);
  info.delta  = sqrt(info.delta);

  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED ) continue;
    ppt->color = 0;
    ppt->tmp   = 0;
  }

  /* ajust relative values */
  d = 0.001 * info.delta;
  if ( opts.bande < 0.0 )  opts.bande = d;

  if ( opts.ctrl & REL )  {
    opts.bande = fabs(opts.bande * d);
    if ( opts.hmin > 0.0 )  opts.hmin = fabs(opts.hmin * d);
    if ( opts.hmax > 0.0 )  opts.hmax = fabs(opts.hmax * d);
  }

  if ( opts.hmin < 0.0 )  opts.hmin = 5.0 * d;
  if ( opts.hmax < 0.0 )  opts.hmax = 0.25 * info.delta;
  E_pop();
  return(1);
}

