/* 
 *  swap edge i of face k
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern int *heap;


int swapar(pSurfMesh sm,int k,int i,float *n1,float *n2,
           float q1,float q2,float hd1,float hd2) {
  pTriangle   pt,pt1,pta;
  int         i1,i2,iv,adj,voy,a,b,c,d,aadj,ppre,ref;

  /* default */
  pt  = &sm->tria[k];
  adj = pt->adj[i];
  voy = pt->voy[i];
  ref = pt->edg[i];
  pt1 = &sm->tria[adj];
  i1 = idir[i+1];
  i2 = idir[i+2];

  a = pt->v[i];
  b = pt->v[i1];
  d = pt->v[i2];
  c = pt1->v[voy];

  if ( !hpop(b,d) || !hpush(a,c) ) {
    yerr.inderr[0] = k;
    yerr.inderr[1] = adj;
    prierr(ERR,1013);
    return(0);
  }

  aadj = pt->adj[i1];
  ppre = pt->voy[i1];
  pt1->adj[voy] = aadj;
  pt1->voy[voy] = ppre;
  pt1->tag[voy] = pt->tag[i1];
  pt1->edg[voy] = pt->edg[i1];

  if ( aadj ) {
    pta = &sm->tria[aadj];
    if ( pta->adj[ppre] != k ) {
      if ( pta->tag[ppre] & M_NOMANIFOLD ) {
	    do {
	      aadj = pta->adj[ppre];
	      ppre = pta->voy[ppre];
	      pta  = &sm->tria[aadj];
	    }
	    while ( pta->adj[ppre] != k );
      }
      else {
	    yerr.inderr[0] = k;
	    yerr.inderr[1] = aadj;
	    prierr(ERR,1014);
	    return(0);
      }
    }
    pta->adj[ppre] = adj;
    pta->voy[ppre] = voy;
  }

  iv   = idir[voy+1];
  aadj = pt1->adj[iv];
  ppre = pt1->voy[iv];
  pt->adj[i] = aadj;
  pt->voy[i] = ppre;
  pt->tag[i] = pt1->tag[iv];
  pt->edg[i] = pt1->edg[iv];

  if ( aadj ) {
    pta = &sm->tria[aadj];
    if ( pta->adj[ppre] != adj ) {
      if ( pta->tag[ppre] & M_NOMANIFOLD ) {
	    do {
	      aadj = pta->adj[ppre];
	      ppre = pta->voy[ppre];
	      pta  = &sm->tria[aadj];
   	    }
	    while ( pta->adj[ppre] != adj );
      }
      else {
	    yerr.inderr[0] = k;
	    yerr.inderr[1] = aadj;
	    prierr(ERR,1014);
	    return(0);
      }
    }
    pta->adj[ppre] = k;
    pta->voy[ppre] = i;
  }

  pt->adj[i1] = adj;
  pt->voy[i1] = idir[voy+1];
  pt->tag[i1] = M_NOTAG;
  pt->edg[i1] = ref;
  pt->flag1   = sm->mark;

  pt1->adj[iv] = k;
  pt1->voy[iv] = idir[i+1];
  pt1->tag[iv] = M_NOTAG;
  pt1->edg[iv] = ref;
  pt1->flag1   = sm->mark;

  pt->n[0] = n1[0];
  pt->n[1] = n1[1];
  pt->n[2] = n1[2];
  pt->qual = q1;
  pt->dish += hd1;

  pt1->n[0] = n2[0];
  pt1->n[1] = n2[1];
  pt1->n[2] = n2[2];
  pt1->qual = q2;
  pt1->dish += hd2;

  if ( heap ) {
    hipput(sm->tria,k);
    hiprep(sm->tria,adj);
  }
  iv = idir[voy+2];
  pt->v[i2]   = pt1->v[voy];
  pt1->v[iv]  = pt->v[i];
  pt->vn[i2]  = pt1->vn[voy];
  pt1->vn[iv] = pt->vn[i];

  return(1);
}
