#ifdef __cplusplus
extern "C" {
#endif

#ifndef ubyte
typedef unsigned char  ubyte;
#endif

/* Point: Structure that defines a vertex in a mesh. */
typedef struct spoint {
  float   c[3];            /* coordinates           */
  float   size;            /* calculated size       */
  int     tge;             /* tangent at ridge      */
  short   color;
  int     ref;
  int     tmp;
  ubyte   tag;             /* vertex type           */
  ubyte   geom;
  ubyte   flag;
} Point;
typedef Point     * pPoint;

/* Triangle: Structure that defines a triangle in a mesh. */
typedef struct striangle {
  float   n[3];             /* face normal                */
  float   dish;             /* distance to surface        */
  float   qual;             /* triangle quality           */

  int     v[3];             /* array of vertex indices    */
  int     adj[3];           /* array of adjacent trias    */
  int     vn[3];            /* array of vertex normals    */
  int     edg[3];
  int     nxt;
  int     ref;
  short   cc;

  ubyte   voy[3];           /* array of voyeur vertices  */
  ubyte   flag1;
  ubyte   tag[3];           /* array of edge classes     */
  ubyte   flag2;
} Triangle;
typedef Triangle  * pTriangle;

typedef struct squad {
  float    qual;
  float    n[3];
  int      v[4];
  int      adj[4];
  int      ref,edg[4],vn[4];
  short    cc;
  ubyte    flag1,flag2;
  ubyte    voy[4];
  ubyte    tag[4];
} Quad;
typedef Quad * pQuad;

typedef struct {
  int   v[4];
  int   ref;
} Tetra;
typedef Tetra * pTetra;


typedef struct geomsupp {
  float    vn[3];           /* array of vertex normals  */
  float    gap;             /* local gap value          */
  int      new;             /* pointer to new number    */
} GeomSupp;
typedef GeomSupp  * pGeomSupp;

typedef struct geomtge {
  float    t[3];
  int      new;
} Geomtge;
typedef Geomtge   * pGeomtge;

typedef struct metric {
  float k1,k2;
  float m[6];                /* anisotropic metric */
} Metric;
typedef Metric   * pMetric;


/* SurfMesh: Structure that defines a mesh. */
typedef struct smesh {
  int       dim;                /* mesh dimension (2,3)     */
  int       type;
  int       connex;             /* # connected component    */
  int       np,npfixe,npmax;    /* number of vertices       */
  int       ne,nefixe,nemax;    /* number of triangles      */
  int       nq,ntet;            /* quads, ntets             */
  int       nv,nvfixe,nvmax;    /* number of vertex normals */
  int       nafixe,nmfixe;
  int       nt,ntfixe,ntmax;    /* vertex tgtes             */
  int       mark;               /* coloring...              */
  int       ipil;

  char     *infile;
  char     *outfile;

  pPoint    point;          /* array of vertices         */
  pTriangle tria;           /* array of triangles        */
  pTetra    tetra;
  pQuad     quad;
  pGeomSupp geom;           /* pointer to geometric info */
  pGeomtge  tgte;           /* pointer to tge at ridge   */
  pMetric   metric;         /* local metric at vertex    */

  pEdge     edge;
} SurfMesh;
typedef SurfMesh  * pSurfMesh;


#ifdef __cplusplus
}
#endif
