#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define COS145DEG   -0.81915204428899


pStack stinit(int nn) {
  pStack   stack;

  stack = (pStack)M_calloc(1,sizeof(Stack),"stack");
  assert(stack);
  stack->t = (int*)M_malloc((nn+1)*sizeof(int),"stack");
  assert(stack->t);
  stack->cur = nn;

  return(stack);
}


void streset(pStack st) {
  st->in = st->out = 0;
}


void stput(pSurfMesh sm,pStack stack,int k) {
  pTriangle   pt;

  pt = &sm->tria[k];
  if ( !pt->flag1 ) {
    if ( ++stack->in > stack->cur )  return;
    stack->t[stack->in] = k;
    pt->flag1 = 1;
  }
}

int stpop(pSurfMesh sm,pStack stack) {
  pTriangle   pt;
  int         k;

  if ( ++stack->out <= stack->in ) {
    k  = stack->t[stack->out];
    if ( k ) {
      pt = &sm->tria[k];
      pt->flag1 = 0;
    }
    return(k);
  }
  else
    return(0);
}


/* store triangles */
int stqueue(pSurfMesh sm,pStack stack,int ridge) {
  pTriangle   pt;
  int         k;
  ubyte       i;

  streset(stack);
  if ( ridge ) {
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      else if ( pt->flag2 < 10 )  continue;
      for (i=0; i<3; i++) {
        if ( pt->tag[i] > M_NOTAG ) {
	  stput(sm,stack,k);
	  break;
        }
      }
    }
    if ( stack->in )  return(stack->in);
  }

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( pt->v[0] && pt->flag2 > 3 )
      stput(sm,stack,k);
  }

  return(stack->in);
}


/* combine trias into quads */
int stscan(pSurfMesh sm,pStack stack,float declic) {
  pTriangle  pt,pta;
  pPoint     a,b,c;
  double     dd,d1,d2,alpha,ux,uy,uz,vx,vy,vz;
  float      qq,qb,nn[3];
  int        k,adj,nq,iv0,iv1,iv2,iv3;
  ubyte      i,i1,i2,iv,voy;

  nq = 0;
  while ( k = stpop(sm,stack) ) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    else if ( pt->flag2 < 10 )  continue;
  
    /* pick up best adj */
    iv = 4;
    qb = -1.0;
    for (i=0; i<3; i++) {
      if ( pt->tag[i] > M_NOTAG )  continue;
      else if ( abs(pt->adj[i]) > k )  continue;
      adj = pt->adj[i];

      voy = pt->voy[i];
      pta = &sm->tria[adj];
      if ( pta->flag2 < 10 )  continue;

      i1  = idir[i+1];
      i2  = idir[i+2];
      iv0 = pt->v[i];
      iv1 = pt->v[i1];
      iv2 = pta->v[voy];
      iv3 = pt->v[i2];
            
      dd  = pt->n[0]*pta->n[0] + pt->n[1]*pta->n[1] + pt->n[2]*pta->n[2];
      if ( dd < COS12DEG )
        continue;

      /* check for curve angles */
      if ( pt->tag[i2] > M_NOTAG && pta->tag[idir[voy+1]] > M_NOTAG ) {
        a = &sm->point[iv0];
	b = &sm->point[iv1];
	c = &sm->point[iv2];
	
	ux = a->c[0] - b->c[0];
        uy = a->c[1] - b->c[1];
        uz = a->c[2] - b->c[2];
        d1 = ux*ux + uy*uy + uz*uz;

        vx = c->c[0] - b->c[0];
        vy = c->c[1] - b->c[1];
        vz = c->c[2] - b->c[2];
        d2 = vx*vx + vy*vy + vz*vz;

        dd = ux*vx + uy*vy + uz*vz;
        alpha = dd / sqrt(d1*d2);
        if ( alpha < COS145DEG )  continue;
      }
      if ( pt->tag[i1] > M_NOTAG && pta->tag[idir[voy+2]] > M_NOTAG ) {
        a = &sm->point[iv0];
	b = &sm->point[iv3];
	c = &sm->point[iv2];
	
	ux = a->c[0] - b->c[0];
        uy = a->c[1] - b->c[1];
        uz = a->c[2] - b->c[2];
        d1 = ux*ux + uy*uy + uz*uz;

        vx = c->c[0] - b->c[0];
        vy = c->c[1] - b->c[1];
        vz = c->c[2] - b->c[2];
        d2 = vx*vx + vy*vy + vz*vz;

        dd = ux*vx + uy*vy + uz*vz;
        alpha = dd / sqrt(d1*d2);
        if ( alpha < COS145DEG )  continue;
      }

      if ( !qualfa_q(&sm->point[iv0].c[0],&sm->point[iv1].c[0],
                          &sm->point[iv2].c[0],&sm->point[iv3].c[0],&qq,nn) )
	continue;
      else if ( qq > declic && qq > qb ) {
        qb = qq;
        iv = i;
      }
    }

    if ( iv < 3 && qb > declic ) {
      ++nq;
      pta = &sm->tria[pt->adj[iv]];
      voy = pt->voy[iv];
      pta->adj[pt->voy[iv]] = -k;
      pt->adj[iv]           = -pt->adj[iv];
      pt->flag2             = iv;
      pta->flag2            = pt->voy[iv];
    }
  }

  return(nq);
}


#ifdef __cplusplus
}
#endif
