#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int split1(pSurfMesh sm,int k,int i,int *vtx,int *inp) {
  pTriangle    pt,pt1;
  pPoint       p0,p1,p2,p3;
  pGeomSupp    go;
  float       *n1,*n2;
  double       dd;
  int          i1,i2;

  pt  = &sm->tria[k];
  pt->flag1 = sm->mark;
  pt->dish = 0.0f;
  /*pt->ref   = 1;*/

  pt1 = &sm->tria[++sm->ne];
  pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));

  /* update topo */
  i1 = idir[i+1];
  i2 = idir[i+2];

  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  p3 = &sm->point[vtx[i]];

  /* update refs (bug 02/09) */
  if ( pt->edg[i] > 0 )  p3->ref = pt->edg[i]; 

  pt->v[i2]   = pt1->v[i1]   = vtx[i];
  pt->tag[i1] = pt1->tag[i2] = M_NOTAG;
  pt->edg[i1] = pt1->edg[i2] = 0;

  if ( !qualfa(p0->c,p1->c,p3->c,&pt->qual,pt->n) ||
       !qualfa(p0->c,p3->c,p2->c,&pt1->qual,pt1->n) ) {
    yerr.inderr[0] = k;
    prierr(ERR,4006);
    return(0);
  }

  /* compute gap + normal */
  pt->vn[i2] = pt1->vn[i1] = 0;
  if ( inp[i] ) {
    pt->vn[i2] = pt1->vn[i1] = inp[i];
    go = &sm->geom[inp[i]];
  }
  else {
    if ( sm->nv > sm->nvmax-2 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt->vn[i2] = pt1->vn[i1] = sm->nv;
    /* linear interpolation */
    if ( pt->vn[i1] && pt1->vn[i2] ) {
      n1 = sm->geom[pt->vn[i1]].vn;
      n2 = sm->geom[pt1->vn[i2]].vn;
      go->vn[0] = 0.5 * (n1[0]+n2[0]);
      go->vn[1] = 0.5 * (n1[1]+n2[1]);
      go->vn[2] = 0.5 * (n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt->n[0]+pt1->n[0];
      go->vn[1] = pt->n[1]+pt1->n[1];
      go->vn[2] = pt->n[2]+pt1->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go->gap = min(go->gap,go->vn[0]*pt->n[0] + go->vn[1]*pt->n[1] + go->vn[2]*pt->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt1->n[0] + go->vn[1]*pt1->n[1] + go->vn[2]*pt1->n[2]);

  return(1);
}


int split2(pSurfMesh sm,int k,int i,int *vtx,int *inp) {
  pTriangle    pt,pt1,pt2;
  pPoint       p0,p1,p2,p3,p4;
  pGeomSupp    go;
  double       dd;
  float       *n1,*n2;
  int          i1,i2;

  pt  = &sm->tria[k];
  pt->flag1 = sm->mark;
  pt->dish = 0.0f;
  /*pt->ref   = 2;*/

  pt1 = &sm->tria[++sm->ne];
  pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));
  pt2 = &sm->tria[++sm->ne];
  pt2 = (pTriangle)memcpy(pt2,pt,sizeof(Triangle));

  /* update topo */
  i1 = idir[i+1];
  i2 = idir[i+2];

  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  p3 = &sm->point[vtx[i1]];
  p4 = &sm->point[vtx[i2]];

  /* update refs (bug 02/09) */
  if ( pt->edg[i1] > 0 )  p3->ref = pt->edg[i1];
  if ( pt->edg[i2] > 0 )  p4->ref = pt->edg[i2];

  pt->v[i1] = pt1->v[i]  = vtx[i2];
  pt->v[i2] = pt1->v[i2] = pt2->v[i] = vtx[i1];
  pt->tag[i] = pt1->tag[i] = pt1->tag[i1] = pt2->tag[i2] = M_NOTAG;
  pt->edg[i] = pt1->edg[i] = pt1->edg[i1] = pt2->edg[i2] = 0;

  /* update quality */
  if ( !qualfa(p0->c,p4->c,p3->c,&pt->qual,pt->n) ||
       !qualfa(p4->c,p1->c,p3->c,&pt1->qual,pt1->n) ||
       !qualfa(p3->c,p1->c,p2->c,&pt2->qual,pt2->n) ) {
    yerr.inderr[0] = k;
    prierr(ERR,4006);
    return(0);
  }

  /* compute gap + normal */
  pt->vn[i2] = pt1->vn[i2] = pt2->vn[i] = 0;
  pt->vn[i1] = pt1->vn[i]  = 0;

  if ( inp[i1] ) {
    pt->vn[i2] = pt1->vn[i2] = pt2->vn[i] = inp[i1];
    go = &sm->geom[inp[i1]];
  }
  else {
    if ( sm->nv > sm->nvmax-3 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt->vn[i2] = pt1->vn[i2] = pt2->vn[i] = sm->nv;
    if ( pt->vn[i] && pt2->vn[i2] ) {
      n1 = sm->geom[pt->vn[i]].vn;
      n2 = sm->geom[pt2->vn[i2]].vn;
      go->vn[0] = 0.5 *(n1[0]+n2[0]);
      go->vn[1] = 0.5 *(n1[1]+n2[1]);
      go->vn[2] = 0.5 *(n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt->n[0]+pt1->n[0]+pt2->n[0];
      go->vn[1] = pt->n[1]+pt1->n[1]+pt2->n[1];
      go->vn[2] = pt->n[2]+pt1->n[2]+pt2->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go->gap = min(go->gap,go->vn[0]*pt->n[0] + go->vn[1]*pt->n[1] + go->vn[2]*pt->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt1->n[0] + go->vn[1]*pt1->n[1] + go->vn[2]*pt1->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt2->n[0] + go->vn[1]*pt2->n[1] + go->vn[2]*pt2->n[2]);
  

  if ( inp[i2] ) {
    pt->vn[i1] = pt1->vn[i] = inp[i2];
    go = &sm->geom[inp[i2]];
  }
  else {
    if ( sm->nv > sm->nvmax-3 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt->vn[i1] = pt1->vn[i] = sm->nv;
    if ( pt->vn[i] && pt1->vn[i1] ) {
      n1 = sm->geom[pt->vn[i]].vn;
      n2 = sm->geom[pt1->vn[i1]].vn;
      go->vn[0] = 0.5 *(n1[0]+n2[0]);
      go->vn[1] = 0.5 *(n1[1]+n2[1]);
      go->vn[2] = 0.5 *(n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt->n[0]+pt1->n[0];
      go->vn[1] = pt->n[1]+pt1->n[1];
      go->vn[2] = pt->n[2]+pt1->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go->gap = min(go->gap,go->vn[0]*pt->n[0] + go->vn[1]*pt->n[1] + go->vn[2]*pt->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt1->n[0] + go->vn[1]*pt1->n[1] + go->vn[2]*pt1->n[2]);
  
  return(1);
}


int split3(pSurfMesh sm,int k,int *vtx,int *inp) {
  pTriangle     pt,pt1,pt2,pt3;
  pPoint        p0,p1,p2,p3,p4,p5;
  pGeomSupp     go;
  double        dd;
  float        *n1,*n2;

  pt = &sm->tria[k];
  pt->flag1 = sm->mark;
  pt->dish = 0.0f;
  /*pt->ref   = 3;*/

  pt1 = &sm->tria[++sm->ne];
  pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));
  pt2 = &sm->tria[++sm->ne];
  pt2 = (pTriangle)memcpy(pt2,pt,sizeof(Triangle));
  pt3 = &sm->tria[++sm->ne];
  pt3 = (pTriangle)memcpy(pt3,pt,sizeof(Triangle));

  p0 = &sm->point[pt->v[0]];
  p1 = &sm->point[pt->v[1]];
  p2 = &sm->point[pt->v[2]];
  p3 = &sm->point[vtx[0]];
  p4 = &sm->point[vtx[1]];
  p5 = &sm->point[vtx[2]];

  /* update refs (bug 02/09) */
  if ( pt->edg[0] > 0 )  p3->ref = pt->edg[0];
  if ( pt->edg[1] > 0 )  p4->ref = pt->edg[1];
	if ( pt->edg[2] > 0 )  p5->ref = pt->edg[2];

  /* update quality */
  if ( !qualfa(p0->c,p5->c,p4->c,&pt->qual,pt->n) ||
       !qualfa(p5->c,p1->c,p3->c,&pt1->qual,pt1->n) ||
       !qualfa(p4->c,p3->c,p2->c,&pt2->qual,pt2->n) ||
       !qualfa(p3->c,p4->c,p5->c,&pt3->qual,pt3->n) ) {
    yerr.inderr[0] = k;
    prierr(ERR,4006);
    return(0);
  }

  /* update topo */
  pt->v[1]  = pt1->v[0] = pt3->v[0] = vtx[2];
  pt->v[2]  = pt2->v[0] = pt3->v[2] = vtx[1];
  pt1->v[2] = pt2->v[1] = pt3->v[1] = vtx[0];

  pt->tag[0]  = pt1->tag[1] = pt2->tag[2] = M_NOTAG;
  pt->edg[0]  = pt1->edg[1] = pt2->edg[2] = 0;

  pt3->tag[0] = pt3->tag[1] = pt3->tag[2] = M_NOTAG;
  pt3->edg[0] = pt3->edg[1] = pt3->edg[2] = 0;

  /* compute gap + normal */
  pt->vn[1]  = pt1->vn[0] = pt3->vn[0] = 0;
  pt1->vn[2] = pt2->vn[1] = pt3->vn[1] = 0;
  pt->vn[2]  = pt2->vn[0] = pt3->vn[2] = 0;

  if ( inp[2] ) {
    pt->vn[1] = pt1->vn[0] = pt3->vn[0] = inp[2];
    go = &sm->geom[inp[2]];
  }
  else {
    if ( sm->nv > sm->nvmax-4 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt->vn[1] = pt1->vn[0] = pt3->vn[0] = sm->nv;
    if ( pt->vn[0] && pt1->vn[1] ) {
      n1 = sm->geom[pt->vn[0]].vn;
      n2 = sm->geom[pt1->vn[1]].vn;
      go->vn[0] = 0.5 * (n1[0]+n2[0]);
      go->vn[1] = 0.5 * (n1[1]+n2[1]);
      go->vn[2] = 0.5 * (n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt->n[0]+pt1->n[0]+pt3->n[0];
      go->vn[1] = pt->n[1]+pt1->n[1]+pt3->n[1];
      go->vn[2] = pt->n[2]+pt1->n[2]+pt3->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go->gap = min(go->gap,go->vn[0]*pt->n[0] + go->vn[1]*pt->n[1] + go->vn[2]*pt->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt1->n[0] + go->vn[1]*pt1->n[1] + go->vn[2]*pt1->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt3->n[0] + go->vn[1]*pt3->n[1] + go->vn[2]*pt3->n[2]);

  if ( inp[0] ) {
    pt1->vn[2] = pt2->vn[1] = pt3->vn[1] = inp[0];
    go = &sm->geom[inp[0]];
  }
  else {
    if ( sm->nv > sm->nvmax-2 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt1->vn[2] = pt2->vn[1] = pt3->vn[1] = sm->nv;
    if ( pt1->vn[1] && pt2->vn[2] ) {
      n1 = sm->geom[pt1->vn[1]].vn;
      n2 = sm->geom[pt2->vn[2]].vn;
      go->vn[0] = 0.5 * (n1[0]+n2[0]);
      go->vn[1] = 0.5 * (n1[1]+n2[1]);
      go->vn[2] = 0.5 * (n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt1->n[0]+pt2->n[0]+pt3->n[0];
      go->vn[1] = pt1->n[1]+pt2->n[1]+pt3->n[1];
      go->vn[2] = pt1->n[2]+pt2->n[2]+pt3->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go->gap = min(go->gap,go->vn[0]*pt1->n[0] + go->vn[1]*pt1->n[1] + go->vn[2]*pt1->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt2->n[0] + go->vn[1]*pt2->n[1] + go->vn[2]*pt2->n[2]);
  go->gap = min(go->gap,go->vn[0]*pt3->n[0] + go->vn[1]*pt3->n[1] + go->vn[2]*pt3->n[2]);
  

  if ( inp[1] ) {
    pt->vn[2] = pt2->vn[0] = pt3->vn[2] = inp[1];
    go = &sm->geom[inp[1]];
  }
  else {
    if ( sm->nv > sm->nvmax-2 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    go = &sm->geom[++sm->nv];
    pt->vn[2] = pt2->vn[0] = pt3->vn[2] = sm->nv;
    if ( pt->vn[0] && pt2->vn[2] ) {
      n1 = sm->geom[pt->vn[0]].vn;
      n2 = sm->geom[pt2->vn[2]].vn;
      go->vn[0] = 0.5 * (n1[0]+n2[0]);
      go->vn[1] = 0.5 * (n1[1]+n2[1]);
      go->vn[2] = 0.5 * (n1[2]+n2[2]);
    }
    else {
      go->vn[0] = pt->n[0]+pt2->n[0]+pt3->n[0];
      go->vn[1] = pt->n[1]+pt2->n[1]+pt3->n[1];
      go->vn[2] = pt->n[2]+pt2->n[2]+pt3->n[2];
    }
    dd = sqrt(go->vn[0]*go->vn[0] + go->vn[1]*go->vn[1] + go->vn[2]*go->vn[2]);
    if ( dd > 0.0f ) {
      dd = 1.0f / dd;
      go->vn[0] *= dd;
      go->vn[1] *= dd;
      go->vn[2] *= dd;
    }
    go->gap = 1.0f;
  }
  go-> gap = min(go->gap,go->vn[0]*pt->n[0] + go->vn[1]*pt->n[1] + go->vn[2]*pt->n[2]);
  go-> gap = min(go->gap,go->vn[0]*pt2->n[0] + go->vn[1]*pt2->n[1] + go->vn[2]*pt2->n[2]);
  go-> gap = min(go->gap,go->vn[0]*pt3->n[0] + go->vn[1]*pt3->n[1] + go->vn[2]*pt3->n[2]);

  return(1);
}


int split4(pSurfMesh sm,int k,int i) {
  pTriangle    pt,pt1,pta;
  pPoint       p0,p1,p2,p3,p4;
  float        n3[3],n4[3],qq3,qq4;
  int          adj,aadj,i1,i2,jj;
  ubyte        ppre;

  pt  = &sm->tria[k];
  adj = pt->adj[i];

  pt1 = &sm->tria[++sm->ne];
  pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));

  i1 = idir[i+1];
  i2 = idir[i+2];
  jj = pt->voy[i];

  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  p3 = &sm->point[sm->np];

  if ( !qualfa(p0->c,p1->c,p3->c,&pt->qual,pt->n) ||
       !qualfa(p0->c,p3->c,p2->c,&pt1->qual,pt1->n) ) {
    yerr.inderr[0] = k;
    prierr(WAR,4006);
    sm->ne--;
    return(0);
  }
 
  if ( adj ) {
    pta = &sm->tria[adj];
    p4  = &sm->point[pta->v[jj]];
    if ( !qualfa(p4->c,p3->c,p1->c,&qq3,n3) ||
         !qualfa(p4->c,p2->c,p3->c,&qq4,n4) ) {
      yerr.inderr[0] = adj;
      prierr(WAR,4006);
      sm->ne--;
      return(0);
    }
  }

  /* update hash table */
  hpop(pt->v[i1],pt->v[i2]);
  hpush(pt->v[i1],sm->np);
  hpush(pt->v[i2],sm->np);
  hpush(pt->v[i],sm->np);

  /* split edge i */
  pt->v[i2]   = pt1->v[i1]   = sm->np;
  pt->vn[i2]  = pt1->vn[i1]  = sm->nv;
  pt->tag[i1] = pt1->tag[i2] = M_NOTAG;
  pt->edg[i1] = pt1->edg[i2] = 0;

  if ( pt->adj[i1] ) {
    aadj = pt->adj[i1];
    ppre = pt->voy[i1];
    pta  = &sm->tria[aadj];
    if ( pta->adj[ppre] == k )
      pta->adj[ppre] = sm->ne;
    else if ( pt1->tag[i1] & M_NOMANIFOLD ) { /* non-manifold edge */
      do {
        aadj = pta->adj[ppre];
        ppre = pta->voy[ppre];
        pta  = &sm->tria[aadj];
      }
      while ( pta->adj[ppre] != k );
      pta->adj[ppre] = sm->ne;
      pta->voy[ppre] = i1;
    }
    else {
      yerr.inderr[0] = k;
      yerr.inderr[1] = pt->adj[i1];
      prierr(ERR,1014);
      return(-1);
    }
  }
  pt->adj[i1]  = sm->ne;
  pt->voy[i1]  = i2;
  pt1->adj[i2] = k;
  pt1->voy[i2] = i1;

  if ( !adj )  return(1);

  pt  = &sm->tria[adj];
  pt1 = &sm->tria[++sm->ne];
  pt1 = (pTriangle)memcpy(pt1,pt,sizeof(Triangle));

  i1 = idir[jj+1];
  i2 = idir[jj+2];

  p0 = &sm->point[pt->v[jj]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];

  pt->qual  = qq3;
  pt1->qual = qq4;
  memcpy(pt->n,n3,3*sizeof(float));
  memcpy(pt1->n,n4,3*sizeof(float));
  
  hpush(pt->v[jj],sm->np);
  pt->v[i1]   = pt1->v[i2]   = sm->np;
  pt->vn[i1]  = pt1->vn[i2]  = sm->nv;
  pt->tag[i2] = pt1->tag[i1] = M_NOTAG;
  pt->edg[i2] = pt1->edg[i1] = 0;

  if ( pt1->adj[i2] ) {
    aadj = pt->adj[i2];
    ppre = pt->voy[i2];
    pta  = &sm->tria[aadj];
    if ( pta->adj[ppre] == adj )
      pta->adj[ppre] = sm->ne;
    else if ( pt1->tag[i2] & M_NOMANIFOLD ) { /* non-manifold */
      do {
        aadj = pta->adj[ppre];
        ppre = pta->voy[ppre];
        pta  = &sm->tria[aadj];
      }
      while ( pta->adj[ppre] != adj );
      pta->adj[ppre] = sm->ne;
      pta->voy[ppre] = i2;
    }
    else {
      yerr.inderr[0] = adj;
      yerr.inderr[1] = pt->adj[i2];
      prierr(ERR,1014);
      return(-1);
    }
  }
  pt->adj[i2]  = sm->ne;
  pt->voy[i2]  = i1;
  pt1->adj[i1] = adj;
  pt1->voy[i1] = i2;

  pt1->adj[jj] = sm->ne-1;
  pt = &sm->tria[sm->ne-1];
  pt->adj[i] = sm->ne;

  return(1);
}
