/* h-correction procedure */

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int sizcor_a(pSurfMesh sm) {
  pHashtable  pht;
  pPoint      p1,p2;
  pMetric     pm1,pm2;
  double      ux,uy,uz,dd,d1,d2,dh,dd1,dd2,mma[6],mmb[6],ma1[6],mb1[6],m[6];
  double      logh,tail,rap,logs,coef,coef1,coef2;
  float      *ma,*mb;
  int         a,b,i,k,ncor,nc,itour,maxtou;

  /* default values */
  if ( opts.shock < 0.0 )  return(1);
  E_put("sizcor_a");
  if ( imprim < -4 )  primsg(1018);
  logh   = log(opts.shock);
  logs   = 0.001 + logh;
  maxtou = 100;
  ncor   = 0;
  itour  = 0;

  /* reset color */
  ++sm->mark;
  for (k=1; k<=sm->np; k++)
    (&sm->point[k])->color = sm->mark;

  /* analyze mesh edges via hash table */
  do {
    nc = 0;
    opts.hmax = 0.0;
    for (k=3; k<hsize; k++) {
      pht = &hash[k];

      /* analyze linked list */
      while ( pht ) {
        if ( !pht->min )  break;
        a  = pht->min;
        b  = k - pht->min;
        p1 = &sm->point[a];
        p2 = &sm->point[b];
        pm1 = &sm->metric[a];
        pm2 = &sm->metric[b];
        ma  = pm1->m;
        mb  = pm2->m;
				
        opts.hmax = max(opts.hmax,max(p1->size,p2->size));
        if ( p1->color < sm->mark && p2->color < sm->mark ) {
          pht = pht->nxt ? &hash[pht->nxt] : 0;
          continue;
        }

        /* compute edge lengths */
        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];

        d1 =      ma[0]*ux*ux + ma[3]*uy*uy + ma[5]*uz*uz \
           + 2.0*(ma[1]*ux*uy + ma[2]*ux*uz + ma[4]*uy*uz);
        if ( d1 <= 0.0 )  d1 = 0.0;
        dd1 = max(EPSD,sqrt(d1));

        d2 =      mb[0]*ux*ux + mb[3]*uy*uy + mb[5]*uz*uz \
           + 2.0*(mb[1]*ux*uy + mb[2]*ux*uz + mb[4]*uy*uz);
        if ( d2 <= 0.0 )  d2 = 0.0;
        dd2 = max(EPSD,sqrt(d2));

        /* swap vertices */
        if ( dd1 > dd2 ) {
          p1  = &sm->point[b];
          p2  = &sm->point[a];
          pm1 = &sm->metric[b];
          pm2 = &sm->metric[a];
          dd  = dd1;
          dd1 = dd2;
          dd2 = dd;
        }
        rap = dd2 / dd1;
        dh = rap - 1.0;

        if ( fabs(dh) > EPS ) {
          tail = (dd1+dd2+4*sqrt(0.5*(d1+d2))) / 6.0;
          /*
          hp   = sqrt(ux*ux + uy*uy + uz*uz) / dd1; 
          hq   = sqrt(ux*ux + uy*uy + uz*uz) / dd2;
          alpha = hp / hq;
          tail = dd1 * log(alpha)/ (alpha-1.0);
          */
          coef = log(rap) / tail;

          /* update sizes */
          if ( coef > logs ) {
            coef      = exp(tail*logh);
            p2->size  = p1->size * coef;
            p1->color = sm->mark;
            p2->color = sm->mark;
            opts.hmax = max(opts.hmax,p2->size);

            //coef1 = exp(dd2*logh);
            coef1 = 1.0 + logh*dd2;
						coef1 = 1.0 / (coef1*coef1);
            //coef2 = exp(dd1*logh);
            coef2 = 1.0 + logh*dd1;
						coef2 = 1.0 / (coef2*coef2);

            /* metric intersection */
            coef = 1.0 / (coef*coef);
            for (i=0; i<6; i++) {
              mma[i] = pm1->m[i];
              mmb[i] = pm2->m[i];
              ma1[i] = coef2 * mma[i];
              mb1[i] = coef1 * mmb[i];
            }

            if ( simred_a(mma,mb1,m) )
              for (i=0; i<6; i++)  pm1->m[i] = m[i];
            else
              for (i=0; i<6; i++)  pm1->m[i]  = SQRT3DIV2 * (mma[i]+mb1[i]);

            if ( simred_a(ma1,mmb,m) )
              for (i=0; i<6; i++)  pm2->m[i] = m[i];
            else
              for (i=0; i<6; i++)  pm2->m[i] = SQRT3DIV2 * (mmb[i]+ma1[i]);

            nc++;
          }
        }
        /* next edge */
        pht = pht->nxt ? &hash[pht->nxt] : 0;
      }
    }
    ncor += nc;
  } while ( nc && ++itour < maxtou );

  if ( ncor > 0 && abs(imprim) > 3 ) {
    yerr.inderr[0] = ncor;
    yerr.inderr[1] = itour;
    yerr.cooerr[0] = opts.shock;
    primsg(1022);
  }

  E_pop();
  return(1);
}

