/* 
 *  size correction
 *  from the article:  
 *  "H_correction"
 *  H. Borouchaki, F. Hecht and P.J. Frey
 *  IJNME, 1998.
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int sizcor(pSurfMesh sm) {
  pTriangle   pt;
  pPoint      p1,p2;
  double      ax,ay,az,dd,dh;
  double      lograp,logh,logs,tail,coef,rap;
  int         k,i,ncor,nc,it,maxtou;
  ubyte       i1,i2;

  /* default values */
  if ( opts.shock < 0.0f )  return(1);
  E_put("sizcor");
  if ( imprim < -4 )  primsg(1018);
  logh   = log(opts.shock);
  logs   = 0.01 + logh;
  maxtou = 100;
  ncor   = it = 0;

  /* reset color */
  for (k=1; k<=sm->npmax; k++)
    (&sm->point[k])->color = sm->mark;

  do {
    nc = 0;
    opts.hmax = 0.0f;

    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      for (i=0; i<3; i++) {
        if ( pt->adj[i] > k )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        p1 = &sm->point[pt->v[i1]];
        p2 = &sm->point[pt->v[i2]];
        /* swap vertices */
        if ( p1->size > p2->size ) {
          p1 = &sm->point[pt->v[i2]];
          p2 = &sm->point[pt->v[i1]];
        }
        opts.hmax = max(opts.hmax,p1->size);
        opts.hmax = max(opts.hmax,p2->size);
        if ( p1->color < sm->mark-1 && p2->color < sm->mark-1 )  continue;

        /* compute edge size */
        ax = p2->c[0] - p1->c[0];
        ay = p2->c[1] - p1->c[1];
        az = p2->c[2] - p1->c[2];

        rap = p2->size / p1->size;
        dh  = rap - 1.0f;
	dd  = sqrt(ax*ax + ay*ay + az*az);

        if ( fabs(dh) > EPS ) {
	  lograp = log(rap);
	  tail   = dd * dh / (p2->size*lograp);
          coef   = lograp / tail;
	  /* update sizes */
	  if ( coef > logs ) {
	    p2->size  = p1->size * exp(tail*logh);
	    p2->color = sm->mark;
	    opts.hmax = max(opts.hmax,p2->size);
	    nc++;
	  }
        }
      }
    }
    ncor += nc;
    ++sm->mark;
  } while ( nc && ++it < maxtou );

  if ( ncor > 0 && imprim < -4 ) {
    yerr.inderr[0] = ncor;
    yerr.inderr[1] = it;
    yerr.cooerr[0] = opts.shock;
    yerr.cooerr[1] = opts.hmin;
    yerr.cooerr[2] = opts.hmax;
    primsg(1022);
  }

  E_pop();
  return(1);
}



#ifdef __cplusplus
}
#endif
