#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int sident(pSurfMesh sm,int detect) {
  pTriangle  pt,pt1;
  pPoint     ppt,p1,p2;
  Ball       bb;
  double     dhd,d,ux,uy,uz,vx,vy,vz;
  int        i,i1,i2,k,a,b,adj,nbf,nb,nridge,nref;
  ubyte      voy;

  /* default */
  E_put("sident");
  if ( imprim < -4 )   primsg(1012);

  /* reset vertex color */
  sm->mark++;
  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    ppt->color = -1;
    ppt->flag  = 1;
    ppt->tmp   = 0;
  }

  /* analyze mesh faces */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] ) continue;

    /* check face edges */
    for (i=0; i<3; i++) {
      adj = pt->adj[i];
      voy = pt->voy[i];
      if ( detect && !(pt->tag[i] & M_RIDGE_GEO) ) {
        pt1 = &sm->tria[adj];
        dhd = pt->n[0]*pt1->n[0] + pt->n[1]*pt1->n[1] + pt->n[2]*pt1->n[2];
        /* check face angle */
        if ( dhd < opts.ridge ) {
          pt->tag[i]    |= M_RIDGE_GEO;
          pt1->tag[voy] |= M_RIDGE_GEO;
        }
      }

      if ( pt->tag[i] == M_NOTAG )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      a  = pt->v[i1];
      b  = pt->v[i2];
      p1 = &sm->point[a];
      p2 = &sm->point[b];

      p1->tag |= pt->tag[i];
      p2->tag |= pt->tag[i];
      if ( !p1->tmp )  p1->tmp = k;
      if ( pt->adj[i] && !p2->tmp )
        p2->tmp = pt->adj[i];

      /* store number of adjacent faces */
      nbf = 1;
      if ( adj = pt->adj[i] ) {
        pt1 = pt;
        voy = i;
        adj = pt1->adj[voy];
        while ( adj && adj != k ) {
          voy = pt1->voy[voy];
          pt1 = &sm->tria[adj];
          adj = pt1->adj[voy];
          nbf++;
        }
      }

      if ( p1->color == -1 )
        p1->color = p1->flag = nbf;
      else if ( p1->color != nbf )
        p1->tag |= M_CORNER;
    
      if ( p2->color == -1 )
        p2->color = p2->flag = nbf;
      else if ( p2->color != nbf )
        p2->tag |= M_CORNER;
    }
  }

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    for (i=0; i<3; i++) {
      if ( pt->tag[i] > M_NOTAG ) {
        i1 = idir[i+1];
        i2 = idir[i+2];
        p1 = &sm->point[pt->v[i1]];
        p2 = &sm->point[pt->v[i2]];
        p1->color--;
        p2->color--;
      }
    }
  }

  /* analyze mesh vertices */
  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED ) {
      info.nvus++;
      ppt->color = ppt->flag = 0;
      continue;
    }
    
    /* check for corner */
    if ( ppt->color == 0 )
      ppt->tag |= M_CORNER;
    else if ( ppt->color != -ppt->flag )
      ppt->tag |= M_CORNER;

    /* check for geometric corner */
    if ( !(ppt->tag & M_CORNER) ) {
      pt = &sm->tria[ ppt->tmp ];

      /* get ball of vertex k */
      if ( pt->v[0] == k )
        bb.ilist = boulep(sm,ppt->tmp,0,&bb);
      else if ( pt->v[1] == k )
        bb.ilist = boulep(sm,ppt->tmp,1,&bb);
      else
        bb.ilist = boulep(sm,ppt->tmp,2,&bb);
      if ( bb.ilist <= 0 )  continue;

      /* analyze ball of vertex k */
      ux = uy = uz = vx = vy = vz = 0.;
      nb = nridge = nref = 0;
      for (i=1; i<=bb.ilist; i++) {
        i1 = idir[bb.nump[i]+1];
        i2 = idir[bb.nump[i]+2];
        pt = &sm->tria[bb.list[i]];
        a  = pt->v[i1];
        b  = pt->v[i2];
        p1 = &sm->point[a];
        p2 = &sm->point[b];

        if ( pt->tag[i2] > M_NOTAG ) {
          ux = p1->c[0] - ppt->c[0];
          uy = p1->c[1] - ppt->c[1];
          uz = p1->c[2] - ppt->c[2];
          if ( pt->tag[i2] & M_RIDGE_GEO )
            ++nridge;
          else
            ++nref;
          if ( ++nb == 2 )
            break;
        }
        if ( pt->tag[i1] > M_NOTAG ) {
          vx = p2->c[0] - ppt->c[0];
          vy = p2->c[1] - ppt->c[1];
          vz = p2->c[2] - ppt->c[2];
          if ( pt->tag[i1] & M_RIDGE_GEO )
            ++nridge;
          else
            ++nref;
          if ( ++nb == 2 )  break;
        }
      }
      /* check if pending edge */
      if ( nridge == 1 || nref == 1 )
        ppt->tag |= M_CORNER;

      else if ( detect ) {
        /* check geometric corner */
        d = (ux*ux + uy*uy + uz*uz) * (vx*vx + vy*vy + vz*vz);
        if ( d != 0.0 ) {
          d = (ux*vx + uy*vy + uz*vz) / sqrt(d);
          if ( d > -opts.ridge )
            ppt->tag |= M_CORNER;
        }
      }
      ppt->color = ppt->flag = 0;
    }
  }

  E_pop();
  return(1);
}

