#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

      
int dupver(pSurfMesh sm,int k,int i,pPoint p0) {
  pPoint     p1;
  pTriangle  pt1;
  Ball       bb;
  int        l,kk,nk,ifree;

  if ( sm->np > sm->npmax-1 ) {
    yerr.inderr[0] = sm->np;
    yerr.inderr[1] = sm->npmax;
    prierr(WAR,4000);
    return(0);
  }

  /* new point */
  ifree = ++sm->np;
  p1    = &sm->point[ifree];
  p1    = (pPoint)memcpy(p1,p0,sizeof(Point));
  
  bb.ilist = boulep(sm,k,i,&bb);
  for (l=1; l<=bb.ilist; l++) {
    kk  = bb.list[l];
    nk  = bb.nump[l];
    
    pt1 = &sm->tria[kk];
    pt1->v[nk] = ifree;
  }
  
  return(1);
}


int setvoi(pSurfMesh sm,int detect) {
  pTriangle  pt1,pt2,pt3,pt4,ptx;
  pPoint     p1,p2;
  int        i,k,i1,i2,depart,adj,ipile;
  int        adj3,adj4,pre3,pre4,edg3,edg4,nbm;
  ubyte      voy,voy1,voy2,tag3,tag4,prex,pre;

  /* default values */
  E_put("setvoi");
  if ( imprim < -4 )  primsg(1010);
  sm->mark++;
  depart = 1;

  /* analyze all triangles */
  nbm = 0;
  while ( TRUE ) {
    pt1   = 0;
    ipile = 0;
    /* find a triangle not yet analyzed */
    for (k=depart; k<=sm->nefixe; k++) {
      pt1 = &sm->tria[k];
      if ( !pt1->v[0] )  continue;
      if ( !pt1->cc ) {
        hash[++ipile].ind = k;
        pt1->cc = ++info.cc;
        depart  = k+1;
        break;
      }
    }
    if ( !ipile || !pt1 )  {
      if ( nbm && abs(imprim) > 4 ) {
        yerr.inderr[0] = nbm;
        primsg(1099);
      }
      E_pop();
      return(1);
    }

    do {
      /* analyze triangle edges */
      for (i=0; i<3; i++) {
        pt1->flag1 = sm->mark;
        adj =  pt1->adj[i];
        voy =  pt1->voy[i];
        pt2 = &sm->tria[adj];
        i1 = idir[i+1];
        i2 = idir[i+2];
        p1 = &sm->point[pt1->v[i1]];
        p2 = &sm->point[pt1->v[i2]];

        /* check point multiple */
        if ( p1->color && (p1->color != info.cc) && !(p1->tag & M_CORNER) ) {
          nbm++;
          p1->color = info.cc;
          if ( opts.ptmult ) 
            dupver(sm,k,i1,p1);
          else if ( detect ) {
            p1->tag  |= M_CORNER;
          }
        }
        else
          p1->color = info.cc;

        if ( p2->color && (p2->color != info.cc) && !(p2->tag & M_RIDGE_GEO) ) {
          nbm++;
          p2->color = info.cc;
          if ( opts.ptmult ) 
            dupver(sm,k,i2,p2);
          else if ( detect ) {
            p2->tag  |= M_CORNER;
          }
        }
        else
          p2->color = info.cc;

        /* check if adjacent triangle */
        if ( !adj ) {
          pt1->tag[i] |= M_RIDGE_GEO;
          p1->tag     |= M_RIDGE_GEO;
          p2->tag     |= M_RIDGE_GEO;
          continue;
        }
        else if ( !pt2->cc && !(pt1->tag[i] & M_NOMANIFOLD) ) {
          hash[++ipile].ind = adj;
          pt2->cc = info.cc;
        }

        /* check for non-manifold model */
        if ( pt1->tag[i] & M_NOMANIFOLD ) {
          pt1->tag[i]   |= M_RIDGE_GEO;
          pt2->tag[voy] |= (M_RIDGE_GEO + M_NOMANIFOLD);
          p1->tag       |= M_RIDGE_GEO;
          p2->tag       |= M_RIDGE_GEO;
          info.manifold  = FALSE;
          continue;
        }
        else if ( pt2->adj[voy] != k ) {
          yerr.inderr[0] = k;
          yerr.inderr[1] = adj;
          prierr(ERR,1010);
          return(0);
        }

        /* check orientation consistency with adjacent face */
        voy1 = idir[voy+1];
        voy2 = idir[voy+2];
        if ( pt1->v[i1] != pt2->v[voy2] ) {
          /* detect moebius strip */
          if ( pt2->flag1 == sm->mark ) {
            yerr.inderr[0] = k;
            prierr(ERR,1011);
            /* return(0);*/
            /* modif 03-09-2003 */
            pt1->tag[i]   |= M_RIDGE_REF;
            pt2->tag[voy] |= M_RIDGE_REF;
            continue;
          }
          /* flip infos. */
          info.flip++;
          pt2->flag1 = sm->mark;

          pt2->v[voy1] = pt1->v[i2];
          pt2->v[voy2] = pt1->v[i1];
          pt2->n[0] = -pt2->n[0];
          pt2->n[1] = -pt2->n[1];
          pt2->n[2] = -pt2->n[2];

          /* update neighbor 1 */
          adj3 = pt2->adj[voy1];
          pre3 = pt2->voy[voy1];
          tag3 = pt2->tag[voy1];
          edg3 = pt2->edg[voy1];
          if ( adj3 ) {
            pt3 = &sm->tria[adj3];
            if ( pt3->adj[pre3] == adj )
              pt3->voy[pre3] = voy2;
            else {
              ptx  = pt3;
              prex = pre3;
              do {
                pre = ptx->voy[prex];
                ptx = &sm->tria[ptx->adj[prex]];
                prex = pre;
              } while ( ptx->adj[prex] != adj );
              ptx->voy[prex] = voy2;
            }
          }

          /* update neighbor 2 */
          adj4 = pt2->adj[voy2];
          pre4 = pt2->voy[voy2];
          tag4 = pt2->tag[voy2];
          edg4 = pt2->edg[voy2];
          if ( adj4 ) {
            pt4 = &sm->tria[adj4];
            if ( pt4->adj[pre4] == adj )
              pt4->voy[pre4] = voy1;
            else {
              ptx  = pt4;
              prex = pre4;
              do {
                pre = ptx->voy[prex];
                ptx = &sm->tria[ptx->adj[prex]];
                prex = pre;
              } while ( ptx->adj[prex] != adj );
              ptx->voy[prex] = voy1;
            }
          }

          /* update adjacency relations */
          pt2->adj[voy1] = adj4;
          pt2->voy[voy1] = pre4;
          pt2->tag[voy1] = tag4;
          pt2->edg[voy1] = edg4;
          pt2->adj[voy2] = adj3;
          pt2->voy[voy2] = pre3;
          pt2->tag[voy2] = tag3;
          pt2->edg[voy2] = edg3;
        }

        /* check edge references */
        if ( pt1->edg[i] && pt1->edg[i] != pt1->ref ) {
          pt1->tag[i]   |= M_RIDGE_REF;
          pt2->tag[voy] |= M_RIDGE_REF;
          p1->tag       |= M_RIDGE_REF;
          p2->tag       |= M_RIDGE_REF;
        }
        if ( pt2->edg[voy] && pt2->edg[voy] != pt2->ref ) {
          pt1->tag[i]   |= M_RIDGE_REF;
          pt2->tag[voy] |= M_RIDGE_REF;
          p1->tag       |= M_RIDGE_REF;
          p2->tag       |= M_RIDGE_REF;
        }
        if ( pt1->edg[i] != pt2->edg[voy] ) {
          pt1->tag[i]   |= M_RIDGE_REF;
          pt2->tag[voy] |= M_RIDGE_REF;
          p1->tag       |= M_RIDGE_REF;
          p2->tag       |= M_RIDGE_REF;
          if ( pt1->edg[i] )
            pt2->edg[voy] = pt1->edg[i];
          else
            pt1->edg[i] = pt2->edg[voy];
        }

        /* check ridge coherence */
        if ( pt1->ref != pt2->ref ) {
          pt1->tag[i]   |= M_RIDGE_REF;
          pt2->tag[voy] |= M_RIDGE_REF;
          p1->tag       |= M_RIDGE_REF;
          p2->tag       |= M_RIDGE_REF;
        }
        else if ( pt1->tag[i] != pt2->tag[voy] ) {
          yerr.coderr = 1012;
          yerr.inderr[0] = k;
          yerr.inderr[1] = adj;
          prierr(WAR,1012);
          if ( pt1->tag[i] )
            pt2->tag[voy] = pt1->tag[i];
          else if ( pt2->tag[voy] )
            pt1->tag[i] = pt2->tag[voy];
          else {
            pt1->tag[i] |= M_REQUIRED;
            p1->tag     |= M_REQUIRED;
            p2->tag     |= M_REQUIRED;
          }
        }
        pt2->flag1 = sm->mark;
      }
      k   = hash[ipile--].ind;
      pt1 = &sm->tria[k];
    }
    while ( ipile );
  }

  if ( nbm && abs(imprim) > 4 ) {
    yerr.inderr[0] = nbm;
    primsg(1099);
  }

  E_pop();
  return(1);
}

