#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int rchsub(pSurfMesh sm) {
  pTriangle  pt1,pt2;
  int        cc,ne,i,k,kk,depart,adj,nbcc,ipile;
  int        cctab[11],ccnum[11],ccdep[11];

  /* default */
  yerr.inderr[0] = info.cc;
  E_put("rchsub");
  primsg(5001);

  /* init */
  for (cc=1; cc<=10; cc++)
    cctab[cc] = ccnum[cc] = ccdep[cc] = 0;
  depart = 1;

  ne = 0;
  for (k=1; k<=sm->ne; k++) {
    pt1 = &sm->tria[k];
    if ( pt1->v[0] ) {
      pt1->flag1 = sm->mark;
      pt1->nxt   = ++ne;
    }
  }
  sm->mark++;

  for (cc=1; cc<=info.cc; cc++) {
    pt1   = 0;
    ipile = 0;
    nbcc  = 0;

    /* find a triangle not yet analyzed */
    for (k=1; k<=sm->ne; k++) {
      pt1 = &sm->tria[k];
      if ( pt1->v[0] == 0 || pt1->cc != cc ) continue;
      depart = k;
      hash[++ipile].ind = k;
      break;
    }
    if ( ipile == 0 ) {
      yerr.inderr[0] = cc;
      prierr(WAR,1020);
      continue;
    }
    else {
      k   = hash[ipile].ind;
      pt1 = &sm->tria[k]; 
      pt1->flag1 = sm->mark;
      do {
	nbcc++;
	for (i=0; i<3; i++) {
	  if ( pt1->tag[i] & M_NOMANIFOLD ) continue;
	  adj = pt1->adj[i];
	  if ( !adj )  continue;

	  pt2 = &sm->tria[adj];
	  if ( pt2->flag1 != sm->mark ) {
	    hash[++ipile].ind = adj;
	    pt2->flag1 = sm->mark;
	  }
	}
	k   = hash[ipile--].ind;
	pt1 = &sm->tria[k];
      }
      while (ipile);

      /* insert in table */
      for (kk=10; kk>0; kk--)
        if ( cctab[kk] < nbcc ) {
	  if ( cctab[kk] > 0 )
	    for (k=1; k<kk; k++) {
	      cctab[k] = cctab[k+1];
	      ccnum[k] = ccnum[k+1];
	      ccdep[k] = ccdep[k+1];
	    }
	  cctab[kk] = nbcc;
	  ccnum[kk] = cc;
	  ccdep[kk] = depart;
	  break;
	}
    }
  }

  for (k=10; k>0; k--) {
    if ( cctab[k] == 0 )  break;
    yerr.inderr[0] = cctab[k];
    yerr.inderr[1] = ccnum[k];
    pt1 = &sm->tria[ccdep[k]];
    yerr.inderr[2] = pt1->nxt;
    primsg(5002);
  }

  E_pop();
  return(1);
}
