#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define EPSZ  1.e-03


/* local curvatures */
int radpoi(pSurfMesh sm) {
  pGeomSupp   geo;
  pTriangle   pt,pt1,pta;
  pPoint      p1,p2;
  Ball        bb;
  double      gap,tail,dd,ux,uy,uz;
  double      x,y,z,x2,xy,y2,z2,maxd,sum,prd,zflat;
  double      ma[6],mb[3],mx[3],keps,reps,rerr;
  float      *np,b1[3],b2[3],c[3],nn[3],k1,k2,kappa;
  int         i,k,kk,nk,l,a,b,i1,i2,nb;

  /* default */
  E_put("radpoi");
  if ( imprim < -4 )  primsg(1015);
  opts.kmin = FLT_MAX;
  opts.kmax = 0.0;
  keps = 2.0 * (1.-opts.eps) * opts.alpha;
  reps = 2.0 * sqrt(2.0*opts.eps) / opts.hmax;
  rerr = 1.0 - ISQRT2;

  /* set max size, if not specified */
  if ( opts.hmax < 0.0 )  opts.hmax = 0.25 * fabs(info.delta);
  if ( opts.hmin > opts.hmax )  opts.hmin = 0.5 * opts.hmax;

  zflat = EPSZ * min(opts.bande,info.delta/1024.0);

  /* dim 2 */
  if ( sm->dim == 2 ) {
    for (k=1; k<=sm->np; k++) {
      p1 = &sm->point[k];
      if ( p1->size < 0.0 )  p1->size = opts.hmax;
    }
    E_pop();
    return(1);
  }

  /* analyze triangle vertices */
  ++sm->mark;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      a  = pt->v[i];
      b  = pt->v[i1];
      p1 = &sm->point[a];
      p2 = &sm->point[b];
      /* check if vertex curvature computed */
      if ( p1->size < 0.0 )  p1->size = opts.hmax;

      /* start along ridge */
      if ( p1->tag & M_CORNER )
        continue;
      else if ( p1->tag > M_NOTAG && pt->tag[i2] == M_NOTAG )
        continue;
      else if ( p1->color == sm->mark )  
        continue;

      geo = &sm->geom[pt->vn[i]];
      np  =  sm->geom[pt->vn[i]].vn;

      /* referentiel (b1,b2,normale) */
      if ( fabs(np[0]) > EPS ) {
	b1[0] = -(np[1]+np[2]) / np[0];
	b1[1] = b1[2] = 1.0f;
      }
      else if ( fabs(np[1]) > EPS ) {
	b1[1] = -(np[0]+np[2]) / np[1];
	b1[0] = b1[2] = 1.0f;
      }
      else if ( fabs(np[2]) > EPS ) {
	b1[2] = -(np[0]+np[1]) / np[2];
	b1[0] = b1[1] = 1.0f;
      }
      else {
	b1[0] = p2->c[0] - p1->c[0];
	b1[1] = p2->c[1] - p1->c[1];
	b1[2] = p2->c[2] - p1->c[2];
	dd = b1[0]*np[0] + b1[1]*np[1] + b1[2]*np[2];
	b1[0] = b1[0] - dd*np[0];
	b1[1] = b1[1] - dd*np[1];
	b1[2] = b1[2] - dd*np[2];
      }
      dd = b1[0]*b1[0] + b1[1]*b1[1] + b1[2]*b1[2];
      if ( dd == 0.0f ) continue;
      dd = 1.0f / sqrt(dd);
      b1[0] *= dd;
      b1[1] *= dd;
      b1[2] *= dd;

      b2[0] = np[1]*b1[2] - np[2]*b1[1];
      b2[1] = np[2]*b1[0] - np[0]*b1[2];
      b2[2] = np[0]*b1[1] - np[1]*b1[0];

      /* get ball of vertex a */
      bb.ilist = boulep(sm,k,i,&bb);
      if ( bb.ilist < 1 )  continue;

      maxd = 0.0;
      for (l=0; l<6; l++)  ma[l] = 0.0f;
      for (l=0; l<3; l++)  mb[l] = mx[l] = 0.0f;
      nb = 0;
      for (l=1; l<=bb.ilist; l++) {
	kk = bb.list[l];
	nk = bb.nump[l];
	i1 = idir[nk+1];
	pt1 = &sm->tria[kk];
	p2  = &sm->point[pt1->v[i1]];
	ux = p2->c[0] - p1->c[0];
	uy = p2->c[1] - p1->c[1];
	uz = p2->c[2] - p1->c[2];

	/* compute gap = angle between normals */
	gap = np[0]*pt1->n[0] + np[1]*pt1->n[1] + np[2]*pt1->n[2];
	if ( gap < geo->gap )  geo->gap = gap;

	/* coordinates of u in local frame */
	x = ux*b1[0] + uy*b1[1] + uz*b1[2];
	y = ux*b2[0] + uy*b2[1] + uz*b2[2];
	z = ux*np[0] + uy*np[1] + uz*np[2];
        x2 = x*x;
        xy = 2*x*y;
        y2 = y*y;
        z2 = z*z;
	ma[0] += x2*x2;
	ma[1] += x2*xy;
	ma[2] += x2*y2;
	ma[3] += 4*x2*y2;
	ma[4] += xy*y2;
	ma[5] += y2*y2;
	mb[0] += x2*z;
	mb[1] += xy*z;
	mb[2] += y2*z;
        if ( maxd < z2 )  maxd = z2;
        nb++;
        
        /* use mid-point */
        if ( coorpo(sm,kk,nk,c,0.5,nn) ) {
          ux = c[0] - p1->c[0];
	  uy = c[1] - p1->c[1];
	  uz = c[2] - p1->c[2];
	  x  = ux*b1[0] + uy*b1[1] + uz*b1[2];
	  y  = ux*b2[0] + uy*b2[1] + uz*b2[2];
	  z  = ux*np[0] + uy*np[1] + uz*np[2];
          x2 = x*x;
          xy = 2*x*y;
          y2 = y*y;
          z2 = z*z;
	  ma[0] += x2*x2;
	  ma[1] += x2*xy;
	  ma[2] += x2*y2;
	  ma[3] += 4*x2*y2;
	  ma[4] += xy*y2;
	  ma[5] += y2*y2;
	  mb[0] += x2*z;
	  mb[1] += xy*z;
	  mb[2] += y2*z;
          if ( maxd < z2 )  maxd = z2;
          nb++;
        }
        
        /* use point voyeur */
        if ( pt1->adj[nk] && pt1->tag[nk] == M_NOTAG ) {
          pta = &sm->tria[pt1->adj[nk]];
          dd  = pt1->n[0]*pta->n[0] + pt1->n[1]*pta->n[1]
              + pt1->n[2]*pta->n[2];
          if ( fabs(dd) > COS1DEG ) {
            i2 = pt1->voy[nk];
	    p2 = &sm->point[pta->v[i2]];
	    ux = p2->c[0] - p1->c[0];
	    uy = p2->c[1] - p1->c[1];
	    uz = p2->c[2] - p1->c[2];
	    x  = ux*b1[0]  + uy*b1[1]  + uz*b1[2];
	    y  = ux*b2[0]  + uy*b2[1]  + uz*b2[2];
	    z  = ux*np[0] + uy*np[1] + uz*np[2];
	    x2 = x*x;
	    y2 = y*y;
	    xy = 2.0*x*y;
	    ma[0] += x2*x2;
	    ma[1] += x2*xy;
	    ma[2] += x2*y2;
	    ma[3] += 4*x2*y2;
            ma[4] += xy*y2;
	    ma[5] += y2*y2;
	    mb[0] += x2*z;
	    mb[1] += xy*z;
	    mb[2] += y2*z;
	    nb++;
          }
        }
      }

      /* last point = last equation */
      if ( bb.closed )
	p1->color = sm->mark;
      else {
        kk = bb.list[bb.ilist];
        nk = bb.nump[bb.ilist];
	i2 = idir[nk+2];
	pt1 = &sm->tria[kk];
	p2  = &sm->point[pt1->v[i2]];
	ux = p2->c[0] - p1->c[0];
	uy = p2->c[1] - p1->c[1];
	uz = p2->c[2] - p1->c[2];

	/* coordinates of u in local frame */
	x = ux*b1[0] + uy*b1[1] + uz*b1[2];
	y = ux*b2[0] + uy*b2[1] + uz*b2[2];
	z = ux*np[0] + uy*np[1] + uz*np[2];
        x2 = x*x;
        xy = 2*x*y;
        y2 = y*y;
        z2 = z*z;
	ma[0] += x2*x2;
	ma[1] += x2*xy;
	ma[2] += x2*y2;
	ma[3] += 4*x2*y2;
	ma[4] += xy*y2;
	ma[5] += y2*y2;
	mb[0] += x2*z;
	mb[1] += xy*z;
	mb[2] += y2*z;
	if ( maxd < z2 )  maxd = z2;
	nb++;

        /* use mid-point */
        if ( coorpo(sm,kk,nk,c,0.5,nn) ) {
          ux = c[0] - p1->c[0];
	  uy = c[1] - p1->c[1];
	  uz = c[2] - p1->c[2];
	  x  = ux*b1[0] + uy*b1[1] + uz*b1[2];
	  y  = ux*b2[0] + uy*b2[1] + uz*b2[2];
	  z  = ux*np[0] + uy*np[1] + uz*np[2];
          x2 = x*x;
          xy = 2*x*y;
          y2 = y*y;
          z2 = z*z;
	  ma[0] += x2*x2;
	  ma[1] += x2*xy;
	  ma[2] += x2*y2;
	  ma[3] += 4*x2*y2;
	  ma[4] += xy*y2;
	  ma[5] += y2*y2;
	  mb[0] += x2*z;
	  mb[1] += xy*z;
	  mb[2] += y2*z;
          if ( maxd < z2 )  maxd = z2;
          nb++;
        }
      }
      /* solve linear system */
      if ( maxd < zflat || nb < 3 )  continue;
      else if ( !sol3x3(ma,mb,mx) )  continue;
      p1->geom = M_CURVE;

      /* compute (accurate) curvatures */
      sum = 2.0*(mx[0]+mx[2]);
      prd = 4.0*(mx[0]*mx[2]-mx[1]*mx[1]);
      dd  = sum*sum - 4.0*prd;
      if ( dd > 0.0 )  dd = sqrt(dd);
      k1 = 0.5 * (sum + dd);
      k2 = 0.5 * (sum - dd);

      /* compute local sizes */
      kappa = max(fabs(k1),fabs(k2));
      tail  = opts.hmax;

      if ( kappa > EPS ) {
     	if ( opts.bande*kappa < rerr )
     	  tail = min(tail,2.0*(1.0-kappa*opts.bande) \
     	       * sqrt(opts.bande*(2.0-kappa*opts.bande)/kappa));
      }
     
      if ( (opts.eps > 0.0) && (kappa > reps) )
        tail = min(tail,keps / kappa);
      tail = max(opts.hmin,tail);

      if ( tail < p1->size )    p1->size  = max(opts.hmin,tail);
      if ( kappa < opts.kmin )  opts.kmin = kappa;
      if ( kappa > opts.kmax )  opts.kmax = kappa;
    }
  }

  E_pop();
  return(1);
}
