#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int radedg_a(pSurfMesh sm) {
  pMetric     pm1;
  pTriangle   pt,pt1;
  pPoint      p1,p2,p3;
  Ball        bb;
  double      nx,ny,nz,ux,uy,uz,vx,vy,vz,tail;
  double      bnx,bny,bnz,tgx,tgy,tgz,dd,keps,reps,rerr;
  float       kappa,k1,k2,e1[3],e2[3];
  int         i,k,kk,i1,i2,a,b,c;
  ubyte       nk,aniso;

  /* default */
  E_put("radedg_a");
  if ( imprim < -4 )  primsg(1016);

  keps = 2.0 * (1.-opts.eps) * opts.alpha;
  reps = 2.0 * sqrt(2.0*opts.eps) / opts.hmax;
  rerr = 1.0 - ISQRT2;
  aniso = !(opts.ctrl & ISO);
  ++sm->mark;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    /* analyze triangle vertices */
    for (i=0; i<3; i++) {
      a  = pt->v[i];
      p1 = &sm->point[a];
	
      if ( p1->tag == M_NOTAG )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      b  = pt->v[i1];
      p2 = &sm->point[b];
      tail = opts.hmax;

      /* internal edge */
      if ( pt->tag[i2] == M_NOTAG ) {
        if ( !(p2->tag & M_CORNER) )  continue;
        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];
        dd = ux*ux + uy*uy + uz*uz;
        if ( dd < EPSD )  continue;
        tail = 0.49 * sqrt(dd);
        if ( tail > opts.hmax )       tail = opts.hmax;
        else if ( tail < opts.hmin )  tail = opts.hmin;
        if ( tail < p1->size )        p1->size  = tail;

        if ( aniso ) {
          pm1 = &sm->metric[a];
          if ( !edgmet_a(p1,pm1,p1->size) )  return(0);
        }
      }
      else {
        if ( p1->tag & M_CORNER )  continue;
        bb.ilist = boulep(sm,k,i,&bb);
        if ( bb.ilist < 1 || bb.closed )  continue;
        kk  = bb.list[bb.ilist];
        nk  = bb.nump[bb.ilist];
        pt1 = &sm->tria[kk];
        i2  = idir[nk+2];
        c   = pt1->v[i2];
        p3  = &sm->point[c];

        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];

        vx = p3->c[0] - p1->c[0];
        vy = p3->c[1] - p1->c[1];
        vz = p3->c[2] - p1->c[2];

        /* compute curve tangent */
        tgx = ux - vx;
        tgy = uy - vy;
        tgz = uz - vz;
        dd  = tgx*tgx + tgy*tgy + tgz*tgz;
        if ( dd < EPSD )  continue;
        dd  = 1.0 / sqrt(dd);
        tgx *= dd;
        tgy *= dd;
        tgz *= dd;

        if ( sm->dim == 2 ) {
          nx  = -tgy;
	        ny  = tgx;
	        nz  = 0.0;
	        bnx = nx;
	        bny = ny;
	        bnz = nz;
		      dd = ux*ux + uy*uy;
	        k1 = 2.0 * fabs((ux*nx + uy*ny) / dd);
	        k2 = 2.0 * fabs((vx*nx + vy*ny) / dd);
	        k1 = max(k1,k2);
		      k2 = 0.0;
	      }
        else {
	        /* compute curve normal */
	        nx = uy*vz - uz*vy;
          ny = uz*vx - ux*vz;
          nz = ux*vy - uy*vx;
          dd = nx*nx + ny*ny + nz*nz;
          if ( dd < EPSD )  continue;
          dd = 1.0 / sqrt(dd);
          nx *= dd;
          ny *= dd;
          nz *= dd;

          /* binormal */
          bnx = tgy*nz - tgz*ny;
          bny = tgz*nx - tgx*nz;
          bnz = tgx*ny - tgy*nx;

          /* compute curvatures */
          dd = ux*ux + uy*uy + uz*uz;
          if ( dd < EPSD )  continue;
          k1 = 2.0 * fabs((ux*bnx + uy*bny + uz*bnz) / dd);

          dd = vx*vx + vy*vy + vz*vz;
          if ( dd < EPSD )  continue;
          k2 = 2.0 * fabs((vx*bnx + vy*bny + vz*bnz) / dd);
        }

        /* update metric */
        if ( aniso ) {
          pm1   = &sm->metric[a];
          e1[0] = tgx;  e1[1] = tgy;  e1[2] = tgz;
          e2[0] = bnx;  e2[1] = bny;  e2[2] = bnz;
          if ( !setmet_a(p1,pm1,k1,k2,e1,e2) )  return(0);
        }
        else {
	        tail  = opts.hmax;
	        kappa = 0.5 * (k1+k2);
          if ( kappa > EPS ) {
            if ( opts.bande*kappa < rerr )
              tail = min(tail,2.0 * (1.0-kappa*opts.bande) \
          	   * sqrt(opts.bande*(2.0-kappa*opts.bande)/kappa));
          }
          if ( (opts.eps > 0.0) && (kappa > reps) )  
            tail = max(tail,keps / kappa);
          tail = max(opts.hmin,tail);
        }

        if ( pt->tag[i] & M_REQUIRED ) {
          dd = ux*ux + uy*uy + uz*uz;
          if ( dd > EPSD )
            tail = min(tail,sqrt(dd));
	        if ( tail < opts.hmin )  tail = opts.hmin;
        }

        if ( tail < p1->size )    p1->size  = tail;
        if ( kappa < opts.kmin )  opts.kmin = kappa;
        if ( kappa > opts.kmax )  opts.kmax = kappa;
      }
    }
  }
    
  E_pop();
  return(1);
}
