/* 
 *  compute face quality (triangle a,b,c) and
 *  normal at triangle
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2003.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <math.h>
#include "yams.h"
#include "extern.h"

/* version 03/09/2002 */
int qualfa_a(float *a,float *b,float *c,pMetric ma,pMetric mb,pMetric mc,
             float *q,float *n) {
  double   ux,uy,uz,vx,vy,vz,wx,wy,wz;
  double   m[6],aire,dd,dd1,dd2,dd3,peri;
  ubyte    l;

  /* average metric */
  for (l=0; l<6; l++)
    m[l] = (ma->m[l]+mb->m[l]+mc->m[l]) / 3.0;

  ux = b[0] - a[0];
  uy = b[1] - a[1];
  uz = b[2] - a[2];
  
  vx = c[0] - a[0];
  vy = c[1] - a[1];
  vz = c[2] - a[2];

  /* normal */
  *q   = 0.0f;
  n[0] = uy*vz - uz*vy;
  n[1] = uz*vx - ux*vz;
  n[2] = ux*vy - uy*vx;
  dd   = n[0]*n[0] + n[1]*n[1] + n[2]*n[2];
  if ( dd <= 0.0f )   return(0);
  dd    = 1.0 / sqrt(dd);
  n[0] *= dd;
  n[1] *= dd;
  n[2] *= dd;

  /* edge lengths */
  wx = c[0] - b[0];
  wy = c[1] - b[1];
  wz = c[2] - b[2];

  dd1 =      m[0]*ux*ux + m[3]*uy*uy + m[5]*uz*uz \
      + 2.0*(m[1]*ux*uy + m[2]*ux*uz + m[4]*uy*uz);
  dd1 = sqrt(dd1);

  dd2 =      m[0]*vx*vx + m[3]*vy*vy + m[5]*vz*vz \
      + 2.0*(m[1]*vx*vy + m[2]*vx*vz + m[4]*vy*vz);
  dd2 = sqrt(dd2);

  dd3 =      m[0]*wx*wx + m[3]*wy*wy + m[5]*wz*wz \
      + 2.0*(m[1]*wx*wy + m[2]*wx*wz + m[4]*wy*wz);
  dd3 = sqrt(dd3);
  
  /* quality */
  peri = 0.5 * (dd1 + dd2 + dd3);
  if ( peri < EPSD )  return(0);
  aire = (peri-dd1) * (peri-dd2) * (peri-dd3);
  if ( aire <= 0.0 )  return(0);
  *q = sqrt(aire * peri) / peri;

  return(1);
}


int updqua_a(pSurfMesh sm) {
  pTriangle  pt;
  pPoint     a,b,c;
  pMetric    ma,mb,mc;
  double     m[6],dd,dd1,dd2,dd3,aire,peri,ux,uy,uz,vx,vy,vz,wx,wy,wz;
  int        k,l;

  info.qworst = 2.0;
  for (k=1; k<sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    a = &sm->point[pt->v[0]];
    b = &sm->point[pt->v[1]];
    c = &sm->point[pt->v[2]];
    
    ma = &sm->metric[pt->v[0]];
    mb = &sm->metric[pt->v[1]];
    mc = &sm->metric[pt->v[2]];
    
    /* average metric */
    for (l=0; l<6; l++)
      m[l] = (ma->m[l]+mb->m[l]+mc->m[l]) / 3.0;

    ux = b->c[0] - a->c[0];
    uy = b->c[1] - a->c[1];
    uz = b->c[2] - a->c[2];
  
    vx = c->c[0] - a->c[0];
    vy = c->c[1] - a->c[1];
    vz = c->c[2] - a->c[2];

    /* normal */
    pt->qual = 0.0f;
    pt->n[0] = uy*vz - uz*vy;
    pt->n[1] = uz*vx - ux*vz;
    pt->n[2] = ux*vy - uy*vx;
    dd   = pt->n[0]*pt->n[0] + pt->n[1]*pt->n[1] + pt->n[2]*pt->n[2];
    if ( dd <= 0.0f )   continue;
    dd = 1.0 / sqrt(dd);
    pt->n[0] *= dd;
    pt->n[1] *= dd;
    pt->n[2] *= dd;

    /* edge lengths */
    wx = c->c[0] - b->c[0];
    wy = c->c[1] - b->c[1];
    wz = c->c[2] - b->c[2];

    dd1 =      m[0]*ux*ux + m[3]*uy*uy + m[5]*uz*uz \
        + 2.0*(m[1]*ux*uy + m[2]*ux*uz + m[4]*uy*uz);
    dd1 = sqrt(dd1);

    dd2 =      m[0]*vx*vx + m[3]*vy*vy + m[5]*vz*vz \
        + 2.0*(m[1]*vx*vy + m[2]*vx*vz + m[4]*vy*vz);
    dd2 = sqrt(dd2);

    dd3 =      m[0]*wx*wx + m[3]*wy*wy + m[5]*wz*wz \
        + 2.0*(m[1]*wx*wy + m[2]*wx*wz + m[4]*wy*wz);
    dd3 = sqrt(dd3);
  
    /* quality */
    peri = 0.5 * (dd1 + dd2 + dd3);
    if ( peri < EPSD )  continue;
    aire = (peri-dd1) * (peri-dd2) * (peri-dd3);
    if ( aire <= 0.0 )  continue;
    pt->qual = sqrt(aire * peri) / peri;
    
    if ( pt->qual < info.qworst )
      info.qworst = pt->qual;
  }

  return(1);
}

double caltri_ani(pSurfMesh sm,int iel,double *n) {
  pTriangle    pt;
  double       cal,rap,ux,uy,uz,vx,vy,vz,h1,h2,h3,vol,dd,det,maxl;
  float       *a,*b,*c,mm[6];
	float       *ma,*mb,*mc;
	int          j;

  pt  = &sm->tria[iel];
  a   = &sm->point[pt->v[0]].c[0];
  b   = &sm->point[pt->v[1]].c[0];
  c   = &sm->point[pt->v[2]].c[0];

  cal = 1.e+20;
  ux = b[0] - a[0];
  uy = b[1] - a[1];
  uz = b[2] - a[2];
  vx = c[0] - a[0];
  vy = c[1] - a[1];
  vz = c[2] - a[2];

  /* face normal */
  n[0] = uy*vz - uz*vy;
  n[1] = uz*vx - ux*vz;
  n[2] = ux*vy - uy*vx;
  vol  = sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
  if ( vol < EPSD )  return(cal);
  dd    = 1.0 / vol;
  n[0] *= dd;
  n[1] *= dd;
  n[2] *= dd;

  /* average metric */
  memset(mm,0,6*sizeof(float));
  ma = &sm->metric[pt->v[0]].m[0];
  mb = &sm->metric[pt->v[1]].m[0];
  mc = &sm->metric[pt->v[2]].m[0];
  for (j=0; j<6; j++)
    mm[j] = (ma[j] + mb[j] + mc[j]) / 3.0;

  det = mm[0] * ( mm[3]*mm[5] - mm[4]*mm[4]) \
      - mm[1] * ( mm[1]*mm[5] - mm[2]*mm[4]) \
      + mm[2] * ( mm[1]*mm[4] - mm[2]*mm[3]);
	det = mm[0]*mm[3] - mm[1]*mm[1];

  if ( det < EPSD )
		return(cal);
	det = sqrt(det) * vol / 2.0;

  h1 =      mm[0]*ux*ux + mm[3]*uy*uy + mm[5]*uz*uz \
     + 2.0*(mm[1]*ux*uy + mm[2]*ux*uz + mm[4]*uy*uz);
	h1 = sqrt(h1);
  h2 =      mm[0]*vx*vx + mm[3]*vy*vy + mm[5]*vz*vz \
     + 2.0*(mm[1]*vx*vy + mm[2]*vx*vz + mm[4]*vy*vz);
	h2 = sqrt(h2);
	maxl = max(h1,h2);
  ux = c[0] - b[0];
  uy = c[1] - b[1];
  uz = c[2] - b[2];
  h3 =      mm[0]*ux*ux + mm[3]*uy*uy + mm[5]*uz*uz \
     + 2.0*(mm[1]*ux*uy + mm[2]*ux*uz + mm[4]*uy*uz);
	h3 = sqrt(h3);
	rap = (h1 + h2 + h3);
	maxl = max(maxl,h3);
	cal = det / (maxl*rap);

	return(cal);
}

#ifdef __cplusplus
}
#endif
