#include <math.h>
#include "yams.h"
#include "defines.h"
#include "extern.h"


int qualfa(float *a,float *b,float *c,float *q,float *n) {
  double   ux,uy,uz,vx,vy,vz,dd,dd1;

  ux = b[0] - a[0];
  uy = b[1] - a[1];
  uz = b[2] - a[2];

  vx = c[0] - a[0];
  vy = c[1] - a[1];
  vz = c[2] - a[2];

  /* face normal */
  *q   = 0.0;
  n[0] = uy*vz - uz*vy;
  n[1] = uz*vx - ux*vz;
  n[2] = ux*vy - uy*vx;
  dd1  = n[0]*n[0] + n[1]*n[1] + n[2]*n[2];
  if ( dd1 < 0.0 )  return(0);
  else if ( dd1 == 0.0 )  return(1);
  dd1 = sqrt(dd1);
  *q  = dd1;
  dd1 = 1.0 / dd1;
  n[0] *= dd1;
  n[1] *= dd1;
  n[2] *= dd1;

  /* edge lengths */
  dd  = ux*ux + uy*uy + uz*uz;
  dd += vx*vx + vy*vy + vz*vz;

  ux = c[0] - b[0];
  uy = c[1] - b[1];
  uz = c[2] - b[2];
  dd += ux*ux + uy*uy + uz*uz;

  if ( dd > 0.0 )
    (*q) /= (float)dd;

  return(1);
}


static float angqua(float *a,float *b,float *c,float *n) {
  double     alpha,dd,d1,d2,ux,uy,uz,vx,vy,vz;

  ux = b[0] - a[0];
  uy = b[1] - a[1];
  uz = b[2] - a[2];
  d1 = ux*ux + uy*uy + uz*uz;

  vx = c[0] - a[0];
  vy = c[1] - a[1];
  vz = c[2] - a[2];
  d2 = vx*vx + vy*vy + vz*vz;

  n[0] = uy*vz - uz*vy;
  n[1] = uz*vx - ux*vz;
  n[2] = ux*vy - uy*vx;
  dd   = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
  n[0] *= dd;
  n[1] *= dd;
  n[2] *= dd;

  dd = (ux*vx + uy*vy + uz*vz) / sqrt(d1*d2);
  alpha = acos(dd);
  if ( alpha <= M_PI_2 )
    return(alpha / M_PI_2);
  else if ( alpha <= M_PI )
    return(2.0 - alpha / M_PI_2);
  else
    return(0.0);
}


int qualfa_q(float *a,float *b,float *c,float *d,float *q,float *n) {
  double   dd;
  float    n1[3],n2[3],n3[3],n4[3],q1,q2;

  *q = 0.0;
  q1 = angqua(a,b,d,n1);
  q2 = angqua(c,d,b,n2);
  if ( n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2] <= 0.0 ) {
    *q = 0.0;
    return(0);
  }
  *q = min(q1,q2);

  q1 = angqua(b,c,a,n3);
  if ( n1[0]*n3[0] + n1[1]*n3[1] + n1[2]*n3[2] <= 0.0 ) {
    *q = 0.0;
    return(0);
  }
  *q = min(*q,q1);

  q2 = angqua(d,a,c,n4);
  if ( q2 <= 0.0 )
    return(0);
  else if ( n3[0]*n4[0] + n3[1]*n4[1] + n3[2]*n4[2] <= 0.0 ) {
    *q = 0.0;
    return(0);
  }
  *q = min(*q,q2);

  n[0] = 0.5 * (n1[0] + n2[0]);
  n[1] = 0.5 * (n1[1] + n2[1]);
  n[2] = 0.5 * (n1[2] + n2[2]);
  dd   = n[0]*n[0] + n[1]*n[1] + n[2]*n[2];
  if ( dd < EPS ) {
    *q = 0.0;
    return(0);
  }
  dd   = 1.0 / sqrt(dd);
  n[0] *= dd;
  n[1] *= dd;
  n[2] *= dd;

  return(*q > EPS);
}
