#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


static int boulev(pSurfMesh sm,int depart,int i) {
  pTriangle  pt;
  int        adj,ilist;
  ubyte      voy;

  /* start from initial face */
  ilist  = 1;
  pt  = &sm->tria[depart] ;
  voy = idir[i+1];
  adj = pt->adj[voy];

  /* search triangles in ball */
  while ( (adj != depart) && !(pt->tag[voy] & M_NOMANIFOLD) ) {
    ++ilist;
    voy = pt->voy[voy];
    voy = idir[voy+2];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
    if ( !adj )  break;
  }

  /* check open ball */
  if ( adj == depart && !(pt->tag[voy] & M_NOMANIFOLD) )
    return(ilist);

  /* re-start from initial face */
  pt  = &sm->tria[depart];
  voy = idir[i+2];
  adj = pt->adj[voy];

  while ( (adj != depart) && !(pt->tag[voy] & M_NOMANIFOLD) ) {
    ++ilist;
    voy = pt->voy[voy];
    voy = idir[voy+1];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
    if ( !adj )  break;
  }

  return(ilist);
}


int ptmult(pSurfMesh sm) {
  pTriangle   pt;
  pPoint      p1;
  int         i,k,nb,nbb;

  E_put("ptmult");
  for (k=1; k<=sm->nefixe; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      p1 = &sm->point[pt->v[i]];
      p1->tmp++;
      p1->flag = sm->mark;
    }
  }

  ++sm->mark;
  nbb = 0;
  for (k=1; k<=sm->nefixe; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      p1 = &sm->point[pt->v[i]];

      if ( p1->tag > M_NOTAG )    continue;
      if ( p1->flag == sm->mark ) continue;
      p1->flag = sm->mark;
      nb = boulev(sm,k,i);
      if ( nb != p1->tmp ) {
		p1->tag |= M_CORNER + M_RIDGE_GEO;
        nbb++;
        if ( imprim < -4 ) {
          yerr.inderr[0] = pt->v[i];
          yerr.inderr[1] = nb;
          yerr.inderr[2] = p1->tmp;
          primsg(1098);
        }
      }
    }
  }

  if ( nbb && abs(imprim) > 4 ) {
    yerr.inderr[0] = nbb;
    primsg(1099);
  }

  E_pop();
  return(1);
}
