/*
 *  print cpu time requirements
 *
 *  Written by Pascal J. Frey
 *  email: Pascal.Frey@inria.fr, 1999
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern mytime  ctim[TIMEMAX];


void pritim(pSurfMesh sm,int option) {
  double   ttot,ttim[TIMEMAX];
  int      k,ne,call[TIMEMAX];

  /* default */
  E_put("pritim");
  for (k=0; k<TIMEMAX; k++) {
    call[k] = ctim[k].call;
    ttim[k] = ctim[k].call ? gttime(ctim[k]) : 0.0;
  }

  ttot    = ttim[2]+ttim[3]+ttim[4]+ttim[5]+ttim[8];
  ttim[0] = max(ttim[0],ttot);
  if ( option > 0 )
    ne = max(sm->nefixe,sm->ne);
  else
    ne = sm->nefixe;

  if ( imprim < 0 ) {
    fprintf(stdout,"\n  -- CPU REQUIREMENTS\n");

    if ( call[2] )
      fprintf(stdout,"  yamsini   %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[2]/ttim[0],call[2],ttim[2]/(float)call[2]);
    if ( call[8] )
      fprintf(stdout,"  metric    %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[8]/ttim[0],call[8],ttim[8]/(float)call[8]);
    if ( call[4] )
      fprintf(stdout,"  remeshing %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[4]/ttim[0],call[4],ttim[4]/(float)call[4]);
    if ( call[7] )
      fprintf(stdout,"   addpoi   %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[7]/ttim[0],call[7],ttim[7]/(float)call[7]);
    if ( call[3] && ttim[3] > 0. )
      fprintf(stdout,"  optim     %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[3]/ttim[0],call[3],ttim[3]/(float)call[3]);
    if ( call[9] && ttim[9] > 0. )
      fprintf(stdout,"   smoothing %8.2f %%    %3d. calls,   %.2f sec/call\n",
	      100.*ttim[9]/ttim[0],call[9],ttim[9]/(float)call[9]);
    fprintf(stdout,"  read/save %8.2f %%    %3d. calls,   %.2f sec/call\n",
	    100.*ttim[5]/ttim[0],call[5],ttim[5]/(float)call[5]);
    fprintf(stdout,"  total     %8.2f %%    %3d. calls,   %.2f sec/call\n",
	    100.*ttot/ttim[0],call[0],ttot/(float)call[0]);
  }

  fprintf(stdout,"\n   ELAPSED TIME  %.2f SEC. ( %.2f )\n",
          (float)ttim[0],(float)ttim[1]);  
  if ( ttim[0] > 10.0 )
    fprintf(stdout,"   %d ELEMENTS ( %d ) WITHIN A MN. FOR %s\n",
	    (int)(60.0*ne/ttim[0]),(int)(60.0*ne/ttim[1]),sm->infile);
  else
    fprintf(stdout,"   %d ELEMENTS ( %d ) WITHIN A SEC. FOR %s\n",
	    (int)(ne/ttim[0]),(int)(ne/ttim[1]),sm->infile);
            
  E_pop();
}


#ifdef __cplusplus
}
#endif
