#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


void priout(pSurfMesh sm) {
  pTriangle  pt1;
  pPoint     ppt;
  int        k,np,ne;

  /* mark connected component */
  E_put("priout");
  ne = 0;
  if ( sm->connex > 0 ) {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      ppt->tag |= M_UNUSED;
      ppt->flag = 0;
    }
    for (k=1; k<=sm->ne; k++) {
      pt1 = &sm->tria[k];
      if ( pt1->v[0] > 0 && pt1->cc == sm->connex ) {
	ne++;
	ppt = & sm->point[pt1->v[0]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[1]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[2]];
	ppt->tag &= ~M_UNUSED;
      }
    }
  }

  /* mark used vertices */
  np = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    if ( ppt->tag & M_UNUSED )
      continue;
    ppt->tmp = ++np;
  }

  /* mark used faces */
  if ( sm->connex == 0 ) {
    ne = 0;
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( pt1->v[0] == 0 )
	continue;
      ++ne;
    }
  }

  /* print out stats */
  fprintf(stdout,"     NUMBER OF GIVEN VERTICES    %8d\n",sm->npfixe);
  fprintf(stdout,"     NUMBER OF GIVEN TRIANGLES   %8d\n",sm->nefixe);
  fprintf(stdout,"     TOTAL NUMBER OF VERTICES    %8d\n",np);
    if ( ne < sm->nefixe )
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d   (%6.2f %%)\n",
	      ne,100*(float)ne/(float)sm->nefixe);
    else
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d\n",ne);
    if ( info.cc > 1 ) 
      fprintf(stdout,"     NUMBER OF SUB-DOMAINS       %8d\n",info.cc);
    if ( sm->connex > 0 )
      fprintf(stdout,"     SUB-DOMAIN TREATED          %8d\n",sm->connex);

  E_pop();
}


#ifdef __cplusplus
}
#endif
