#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


#define STR "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
static  char  msg[][20] = {
 "DEFAULT", "SURFACE ANALYSIS", "SURFACE REMESHING", "MESH OPTIMIZATION", "QUAD CONVERSION" };

void primsg(int indice) {
  int level;

  level = indice / 1000;

  if ( level == 0 ) {
    switch (indice) {
    case 0000:
      if ( opts.ctrl & ISO )
        fprintf(stdout,"\n  %s\n   MODULE YAMS-LJLL : %s\n  %s\n",
	        STR,VERSION,STR);
      else
        fprintf(stdout,"\n  %s\n   MODULE YAMS-LJLL (ANISO) : %s\n  %s\n",
	        STR,VERSION,STR);
      return;
    case 0001: 
      fprintf(stdout,"\n  %s\n   END OF MODULE YAMS\n  %s\n\n",STR,STR);
      return;
    case 0002:
      fprintf(stdout,"  MAXIMUM NUMBER OF POINTS      (NPMAX) : %10d\n",
	      yerr.inderr[0]);
      fprintf(stdout,"  MAXIMUM NUMBER OF ELEMENTS    (NEMAX) : %10d\n",
	      yerr.inderr[1]);
      return;
    }
  }

  else if ( level == 1 ) {
    switch (indice) {
    case 1000:
      fprintf(stdout,"\n  -- PHASE %2d : %s\n",yerr.inderr[0],msg[yerr.inderr[0]]);
      return;
    case 1001:
      fprintf(stdout,"  -- PHASE %2d COMPLETED.       %.2f sec.\n",
	      yerr.inderr[0],yerr.cooerr[0]);
      return;
    case 1010: 
      fprintf(stdout,"  ** SETTING ADJACENCIES\n");
      return;
    case 1011: 
      fprintf(stdout,"  ** COMPUTING VERTEX NORMALS\n");
      return;
    case 1012: 
      fprintf(stdout,"  ** CHECKING SINGULARITY\n");
      return;
    case 1013:
      fprintf(stdout,"  ** REMOVING NULL FACES\n");
      return;
    case 1014:      
      fprintf(stdout,"     %7d FACES REMOVED, %d SWAPPED (%d EXISTING)\n",
	      yerr.inderr[2],yerr.inderr[1],yerr.inderr[0]);
      return;
    case 1015:
      fprintf(stdout,"  ** COMPUTING CURVATURES\n");
      return;
    case 1016:
      fprintf(stdout,"  ** COMPUTING RIDGE CURVATURES\n");
      return;
    case 1017:
      fprintf(stdout,"  ** TRUNCATING METRIC\n");
      return;
    case 1018:
      fprintf(stdout,"  ** SIZE CORRECTION\n");
      return;
    case 1021:
      fprintf(stdout,"     SIZES : HMIN %f  HMAX %f\n",yerr.cooerr[0],yerr.cooerr[1]);
      return;
    case 1022:
      fprintf(stdout,"     %7d SIZES ADJUSTED (GRAD.= %g, ITER= %d)\n",
	      yerr.inderr[0],yerr.cooerr[0],yerr.inderr[1]);
      if ( opts.ctrl & ISO )
        fprintf(stdout,"     SIZES : HMIN %f  HMAX %f\n",
                yerr.cooerr[1],yerr.cooerr[2]);
      return;
    case 1023:
      fprintf(stdout,"     %7d QUADRICS STORED (%.2f %%)\n",
	      yerr.inderr[0],(100.*yerr.inderr[0])/yerr.inderr[1]);
      return;
    case 1030:
      fprintf(stdout,"  ** GARBAGING ELEMENTS\n");
      return;
    case 1040:
      fprintf(stdout,"  REALLOC %d NORMALS\n",yerr.inderr[0]);
      return;
    case 1041:
      fprintf(stdout,"  REALLOC %d TANGENTS\n",yerr.inderr[0]);
      return;
    case 1050:
      fprintf(stdout,"  ** NO-SHRINKAGE SURFACE SMOOTHING\n");
      return;
    case 1098:
      fprintf(stdout,"     POINT %d:  BALL %d   COUNT %d\n",yerr.inderr[0],
              yerr.inderr[1],yerr.inderr[2]);
      return;
    case 1099:
      fprintf(stdout,"  -- %d MULTIPLY CONNECTED POINTS\n",yerr.inderr[0]);
      return;
    }
  }

  else if ( level == 2 ) {
    switch (indice) {
    case 2000:
      fprintf(stdout,"     TOLERANCE %f\n",yerr.cooerr[0]);
      return;
    case 2001:
      fprintf(stdout,"  ** DECIMATION\n");
      return;
    case 2002:
      fprintf(stdout,"  ** VERTEX INSERTION\n");
      return;
    case 2003:
      fprintf(stdout,"     HAUSDORFF step %f\n",yerr.cooerr[0]); 
      return;
    case 2004:
      fprintf(stdout,"  ** GEOMETRY CLEANING\n"); 
      return;
    case 2005:
      fprintf(stdout,"  ** NULL ELIMINATION\n"); 
      return;
    case 2006:
      fprintf(stdout,"  ** GEOMETRY IMPROVEMENT (%.2f deg)\n",yerr.cooerr[0]); 
      return;
    case 2007:
      fprintf(stdout,"     %7d VERTICES PROPOSED\n",yerr.inderr[0]);
      return;
    case 2008:
      fprintf(stdout,"     %7d VERTICES  %7d ELEMENTS CREATED\n",
              yerr.inderr[0],yerr.inderr[1]);
      return;
    case 2009:
      fprintf(stdout,"     %7d EDGE SWAPPED\n",yerr.inderr[0]);
      return;
    case 2010:
      fprintf(stdout,"     %7d INSERTED %7d REMOVED  %7d MOVED\n",
              yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 2011:
      fprintf(stdout,"     %7d INSERTED %7d REMOVED  %7d SWAPPED\n",
              yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 2012:
      fprintf(stdout,"     %7d PROPOSED %7d SWAPPED\n",
              yerr.inderr[0],yerr.inderr[1]);
      return;
    case 2013:
      fprintf(stdout,"     %7d INSERTED %7d REMOVED  %7d SWAPPED  %7d MOVED\n",
              yerr.inderr[0],yerr.inderr[1],yerr.inderr[2],yerr.inderr[3]);
      return;
    case 2014:
      fprintf(stdout,"     %7d TRIANGLES %7d QUADS\n",
              yerr.inderr[0],yerr.inderr[1]);
      return;
    }
  }

  else if ( level == 4 ) {
    switch (indice) {
    case 4000:
      fprintf(stdout,"     %7d REMOVED  %7d ADDED\n",yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4001:
      fprintf(stdout,"     %7d REMOVED  %7d SWAPPED  %7d MOVED\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 4002:
      fprintf(stdout,"     %7d INSERTED %7d SWAPPED  %7d MOVED\n",
              yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 4003:
      fprintf(stdout,"     %7d MOVED    %7d SWAPPED   RESIDUAL %.2g\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.cooerr[0]);
      return;
    case 4004:
      fprintf(stdout,"     %7d ADDED    %7d SWAPPED\n",
              yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4005:
      fprintf(stdout,"     %7d REMOVED  %7d SWAPPED  %7d MOVED  (%d,%.2g)\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.inderr[2],
              (int)(yerr.cooerr[0]+0.5),yerr.cooerr[1]);
      return;
    case 4006:
      fprintf(stdout,"     %7d PROPOSED %7d ADDED    %7d SWAPPED\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 4007:
      fprintf(stdout,"     %7d MOVED    %7d SWAPPED\n",
              yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4008:
      fprintf(stdout,"     %7d MOVED    RESIDUAL %.2g\n",
	      yerr.inderr[0],yerr.cooerr[0]);
      return;
    case 4009:
      fprintf(stdout,"     %7d PROPOSED %7d REMOVED  %7d SWAPPED\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 4010:
      fprintf(stdout,"  ** SIZE OPTIMIZATION\n");
      return;
    case 4011:
      fprintf(stdout,"      Enrichment\n");
      return;
    case 4012:
      fprintf(stdout,"      Decimation\n");
      return;
    case 4013:
      fprintf(stdout,"      Mixed mesh creation\n");
      return;
    case 4014:
      fprintf(stdout,"      Splitting mesh\n");
      return;
    
    case 4020:
      fprintf(stdout,"  ** PHASE 31 OPTIMIZATION (OPTBAD)\n");
      return;
    case 4021:
      fprintf(stdout,"  ** PHASE 32 OPTIMIZATION (OPTEDG)\n");
      return;
    case 4022:
      fprintf(stdout,"  ** PHASE 33 OPTIMIZATION (OPTPOS)\n");
      return;
    case 4023:
      fprintf(stdout,"  ** PHASE 33 OPTIMIZATION (OPTSIZ)\n");
      return;
    case 4024:
      fprintf(stdout,"  ** PHASE 33 OPTIMIZATION (OPTQUA)\n");
      return;
    case 4025:
      fprintf(stdout,"  -- R-METHOD ADAPTATION\n");
      return;
    case 4026:
      fprintf(stdout,"  -- FE CORNER PROCESS\n");
      return;
    case 4027:
      fprintf(stdout,"  ** CONVERTING QUADS\n");
      return;
    case 4028:
      fprintf(stdout,"  ** OPTIMIZING QUADS\n");
      return;
    }
  }

  else if ( level == 5 ) {
    switch(indice) {
    case 5001:
      fprintf(stdout,"\n  -- SUB-DOMAINS IDENTIFICATION, %d\n",yerr.inderr[0]);
      return;
    case 5002:
      fprintf(stdout,"     THERE ARE %d TRIANGLES IN SUB-DOMAIN %d   (SEED: %d)\n",
	      yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    }
  }

  else
    fprintf(stdout,"  ## MESSAGE INDEX NOT FOUND %d %d\n",level,yerr.coderr);
}
