/* 
 *  print mesh quality histogram
 *
 *  Written by Pascal J. Frey
 *  email: Pascal.Frey@inria.fr, 1999
*/


#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


void prihis(int *histo10,int *histo1,double rapmin,double rapmax) {
  int     i,imax,j;

  E_put("prihis");
  fprintf(stdout,"\n     HISTOGRAMM\n");

  /* quality between 1 and 9 */
  j = 0;
  for (i=1; i<16; i++)
    j += histo1[i];

  for (i=max((int)rapmin,1); i<=min((int)rapmax,9); i++) {
    fprintf(stdout,"     %5d < Q < %5d   %7d   %6.2f %%\n",
	    i,i+1,histo10[i],100.*(histo10[i]/(float)histo1[0]));
  }

  /* quality per interval */
  if (j != 0) {
    fprintf(stdout,"\n");
    imax = (int)(min(3,log10(rapmax)));

    for (i=1; i<=imax; i++) {
      fprintf(stdout,"     %5.0f < Q < %5.0f   %7d   %6.2f %%\n",
	      pow(10.,i),pow(10.,i+1),histo1[i],100.*(histo1[i]/(float)histo1[0]));
    }
    for (i=4; i<=(int)log10(rapmax); i++) {
      fprintf(stdout,"    10**%2d < Q < 10**%2d  %7d   %6.2f %%\n",
	      i,i+1,histo1[i],100.*(histo1[i]/(float)histo1[0]));
    }
  }
  
  E_pop();
}


#ifdef __cplusplus
}
#endif
