/*
 *  print mesh gaps (edge - tangent plane deviation)
 *  after normalization back
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int prigap(pSurfMesh sm) {
  pTriangle  pt,pt1;
  pPoint     ppt;
  Ball       bb;
  double     dd,gap,gapavg,gapmin,gapmax;
  float     *np;
  int        i,k,l,kg,kk,kmax,a,ngap,nbgap,nnp;
  int        gaph[20];

  /* default */
  if ( sm->dim < 3 ) return(1);
  E_put("prigap");
  gapmin =  1.2;
  gapmax = -1.2;
  gapavg =  0.0f;
  ngap   =  nbgap = 0;
  for (k=0; k<20; k++)  gaph[k] = 0;
  
  /* mark points */
  nnp = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED ) continue;
    ppt->tmp = --nnp;
  }
  if ( !nnp )  {
    E_pop();
    return(1);
  }
  
  kk = a = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] ) continue;
    for (i=0; i<3; i++) {
      ppt = &sm->point[pt->v[i]];
      if ( ppt->tmp > 0 )  continue;

      /* compute local gap */
      np = sm->geom[pt->vn[i]].vn;
      bb.ilist = boulep(sm,k,i,&bb);
      gap = 1.0f;
      for (l=1; l<=bb.ilist; l++) {
	kk  = bb.list[l];
	pt1 = &sm->tria[kk];
	dd  = np[0]*pt1->n[0] + np[1]*pt1->n[1] + np[2]*pt1->n[2];
        if ( dd < gap )  gap = dd;
      }
      
      /* store gap value */
      if ( gap > 1.0f ) gap = 1.0f;
      else if ( gap < -1.0f ) gap = -1.0f;
      gapavg += gap;
      if ( gap >= opts.gap )  nbgap++;
      kg  = (int)(acos(gap)*18./M_PI);
      if ( kg < 20 )  gaph[kg]++;
      if ( gap < gapmin ) {
	gapmin = gap;
	a = pt->v[i];
      }
      if ( gap > gapmax )  gapmax = gap;
      ngap++;
      if ( bb.closed )  ppt->tmp = abs(ppt->tmp);
    }
  }

  /* print approximation histogram */
  if ( ngap > 0 && abs(imprim) > 1 ) {
    yerr.inderr[0] = sm->nefixe;
    gapavg /= ngap;
    fprintf(stdout,"\n  -- GEOMETRIC APPROXIMATION (%d, %.2f deg)\n",
	    ngap,180.*asin(opts.alpha)/M_PI);

    if ( nbgap )
      fprintf(stdout,"     AVERAGE DEVIATION   %10.2f deg    %5.2f %%\n",
              acos(gapavg)*180./M_PI,100.0*(double)nbgap/ngap);
    else  
      fprintf(stdout,"     AVERAGE DEVIATION   %10.2f deg\n",
              acos(gapavg)*180./M_PI);
/*
    fprintf(stdout,"     BEST  DEVIATION     %10.2f deg\n",acos(gapmax)*180./M_PI);
*/  
    fprintf(stdout,"     WORST DEVIATION     %10.2f deg\n",acos(gapmin)*180./M_PI);
    fprintf(stdout,"     WORST VERTEX     %d\n",abs((&sm->point[a])->tmp));
    if ( abs(imprim) > 4 ) {
      kmax = min((int)(acos(gapmin)*18./M_PI),10);
      if ( kmax > 0 ) {
	fprintf(stdout,"\n     HISTOGRAMM\n");
	for (k=0; k<=kmax; k++)
	  fprintf(stdout,"    %5.1f  < D < %5.1f    %7d   %6.2f %%\n",
		  (float)10.*k,10.*(k+1),gaph[k],100. * (float)gaph[k] / (float)ngap);
      }
    }
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
